/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.neometa.structure;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.neo4j.api.core.Direction;
import org.neo4j.api.core.NeoService;
import org.neo4j.api.core.Node;
import org.neo4j.api.core.NotFoundException;
import org.neo4j.api.core.RelationshipType;
import org.neo4j.api.core.Transaction;
import org.neo4j.neometa.structure.DynamicMetaRelTypes;
import org.neo4j.neometa.structure.LookerUpper;
import org.neo4j.neometa.structure.LookupUtil;
import org.neo4j.neometa.structure.MetaStructure;
import org.neo4j.neometa.structure.MetaStructureClass;
import org.neo4j.neometa.structure.MetaStructureNamespace;
import org.neo4j.neometa.structure.MetaStructureObject;
import org.neo4j.neometa.structure.MetaStructureObjectCollection;
import org.neo4j.neometa.structure.MetaStructureProperty;
import org.neo4j.neometa.structure.MetaStructureRelTypes;
import org.neo4j.util.NeoUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaStructureImpl
implements MetaStructure {
    private NeoService neo;
    private NeoUtil neoUtil;
    private DynamicMetaRelTypes dynamicRelTypes = new DynamicMetaRelTypes();
    private Map<String, MetaStructureNamespace> namespaceCache = Collections.synchronizedMap(new HashMap());

    public MetaStructureImpl(NeoService neo) {
        this.neo = neo;
        this.neoUtil = new NeoUtil(neo);
        this.dynamicRelTypes = new DynamicMetaRelTypes();
    }

    public NeoService neo() {
        return this.neo;
    }

    protected NeoUtil neoUtil() {
        return this.neoUtil;
    }

    protected Node rootNode() {
        return this.neoUtil().getOrCreateSubReferenceNode((RelationshipType)MetaStructureRelTypes.REF_TO_META_SUBREF);
    }

    protected DynamicMetaRelTypes dynamicRelTypes() {
        return this.dynamicRelTypes;
    }

    @Override
    public MetaStructureNamespace getNamespace(String name, boolean allowCreate) {
        assert (name != null);
        return this.findOrCreateInCollection(this.getNamespaces(), name, allowCreate, MetaStructureNamespace.class, this.namespaceCache);
    }

    @Override
    public MetaStructureNamespace getGlobalNamespace() {
        return this.findOrCreateInCollection(this.getNamespaces(), null, true, MetaStructureNamespace.class, this.namespaceCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends MetaStructureObject> T findOrCreateInCollection(Collection<T> collection, String nameOrNullForGlobal, boolean allowCreate, Class<T> theClass, Map<String, T> cacheOrNull) {
        Transaction tx = this.neo().beginTx();
        try {
            Iterator<T> i$;
            MetaStructureObject item2;
            Object foundItem = this.safeGetFromCache(cacheOrNull, nameOrNullForGlobal);
            if (foundItem != null) {
                tx.success();
                T t = foundItem;
                return t;
            }
            for (MetaStructureObject item2 : collection) {
                String theName = item2.getName();
                if (nameOrNullForGlobal == null || theName == null) {
                    if (nameOrNullForGlobal != null || theName != null) continue;
                    foundItem = item2;
                    break;
                }
                if (!theName.equals(nameOrNullForGlobal)) continue;
                foundItem = item2;
                break;
            }
            if (foundItem != null) {
                if (cacheOrNull != null) {
                    cacheOrNull.put(nameOrNullForGlobal, foundItem);
                }
                i$ = foundItem;
                return (T)i$;
            }
            if (!allowCreate) {
                i$ = null;
                return (T)i$;
            }
            Node node = this.neo().createNode();
            item2 = null;
            try {
                item2 = (MetaStructureObject)theClass.getConstructor(MetaStructure.class, Node.class).newInstance(this, node);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (nameOrNullForGlobal != null) {
                item2.setName(nameOrNullForGlobal);
            }
            collection.add(item2);
            tx.success();
            MetaStructureObject metaStructureObject = item2;
            return (T)metaStructureObject;
        }
        finally {
            tx.finish();
        }
    }

    private <T extends MetaStructureObject> T safeGetFromCache(Map<String, T> cacheOrNull, String key) {
        MetaStructureObject result = null;
        if (cacheOrNull != null && (result = (MetaStructureObject)cacheOrNull.get(key)) != null) {
            try {
                this.neo().getNodeById(result.node().getId());
            }
            catch (NotFoundException e) {
                cacheOrNull.remove(result);
                result = null;
            }
        }
        return (T)result;
    }

    @Override
    public Collection<MetaStructureNamespace> getNamespaces() {
        return new MetaStructureObjectCollection<MetaStructureNamespace>(this.neo(), this.rootNode(), MetaStructureRelTypes.META_NAMESPACE, Direction.OUTGOING, this, MetaStructureNamespace.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T lookup(MetaStructureProperty property, LookerUpper<T> finder, MetaStructureClass ... classes) {
        Transaction tx = this.neo().beginTx();
        try {
            T result = LookupUtil.lookup(property, finder, classes);
            tx.success();
            T t = result;
            return t;
        }
        finally {
            tx.finish();
        }
    }
}

