/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.neometa.structure;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.api.core.Direction;
import org.neo4j.api.core.Node;
import org.neo4j.neometa.structure.MetaStructure;
import org.neo4j.neometa.structure.MetaStructureClass;
import org.neo4j.neometa.structure.MetaStructureImpl;
import org.neo4j.neometa.structure.MetaStructureObject;
import org.neo4j.neometa.structure.MetaStructureObjectCollection;
import org.neo4j.neometa.structure.MetaStructureProperty;
import org.neo4j.neometa.structure.MetaStructureRelTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaStructureNamespace
extends MetaStructureObject {
    private Map<String, MetaStructureClass> classCache = Collections.synchronizedMap(new HashMap());
    private Map<String, MetaStructureProperty> propertyCache = Collections.synchronizedMap(new HashMap());

    public MetaStructureNamespace(MetaStructure meta, Node node) {
        super(meta, node);
    }

    public MetaStructureClass getMetaClass(String name, boolean allowCreate) {
        return ((MetaStructureImpl)this.meta()).findOrCreateInCollection(this.getMetaClasses(), name, allowCreate, MetaStructureClass.class, this.classCache);
    }

    public Collection<MetaStructureClass> getMetaClasses() {
        return new MetaStructureObjectCollection<MetaStructureClass>(this.neo(), this.node(), MetaStructureRelTypes.META_CLASS, Direction.OUTGOING, this.meta(), MetaStructureClass.class);
    }

    public MetaStructureProperty getMetaProperty(String name, boolean allowCreate) {
        return ((MetaStructureImpl)this.meta()).findOrCreateInCollection(this.getMetaProperties(), name, allowCreate, MetaStructureProperty.class, this.propertyCache);
    }

    public Collection<MetaStructureProperty> getMetaProperties() {
        return new MetaStructureObjectCollection<MetaStructureProperty>(this.neo(), this.node(), MetaStructureRelTypes.META_PROPERTY, Direction.OUTGOING, this.meta(), MetaStructureProperty.class);
    }

    public String toString() {
        String name = (String)this.getProperty("name", "GLOBAL");
        return this.getClass().getSimpleName() + "[" + name + "]";
    }
}

