/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.neometa.structure;

import org.neo4j.api.core.NeoService;
import org.neo4j.api.core.Node;
import org.neo4j.api.core.PropertyContainer;
import org.neo4j.api.core.Relationship;
import org.neo4j.api.core.RelationshipType;
import org.neo4j.api.core.Transaction;
import org.neo4j.neometa.structure.MetaStructure;
import org.neo4j.neometa.structure.MetaStructureImpl;
import org.neo4j.util.NeoUtil;

public abstract class MetaStructureObject {
    static final String KEY_MIN_CARDINALITY = "min_cardinality";
    static final String KEY_MAX_CARDINALITY = "max_cardinality";
    static final String KEY_COLLECTION_CLASS = "collection_class";
    public static final String KEY_NAME = "name";
    private MetaStructure meta;
    private Node node;

    MetaStructureObject(MetaStructure meta, Node node) {
        this.meta = meta;
        this.node = node;
    }

    public MetaStructure meta() {
        return this.meta;
    }

    public NeoService neo() {
        return ((MetaStructureImpl)this.meta()).neo();
    }

    protected NeoUtil neoUtil() {
        return ((MetaStructureImpl)this.meta()).neoUtil();
    }

    public Node node() {
        return this.node;
    }

    protected void setProperty(String key, Object value) {
        this.neoUtil().setProperty((PropertyContainer)this.node(), key, value);
    }

    protected Object getProperty(String key) {
        return this.neoUtil().getProperty((PropertyContainer)this.node(), key);
    }

    protected Object getProperty(String key, Object defaultValue) {
        return this.neoUtil().getProperty((PropertyContainer)this.node(), key, defaultValue);
    }

    protected Object removeProperty(String key) {
        return this.neoUtil().removeProperty((PropertyContainer)this.node(), key);
    }

    protected void setOrRemoteProperty(String key, Object value) {
        if (value == null) {
            this.removeProperty(key);
        } else {
            this.setProperty(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setSingleRelationshipOrNull(Node node, RelationshipType type) {
        Transaction tx = this.neo().beginTx();
        try {
            Relationship relationship = this.getSingleRelationshipOrNull(type);
            if (relationship != null) {
                relationship.delete();
            }
            if (node != null) {
                this.node().createRelationshipTo(node, type);
            }
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    protected Relationship getSingleRelationshipOrNull(RelationshipType type) {
        return this.neoUtil().getSingleRelationship(this.node(), type);
    }

    void setName(String name) {
        this.setProperty(KEY_NAME, name);
    }

    public String getName() {
        return (String)this.getProperty(KEY_NAME, null);
    }

    public int hashCode() {
        return this.node().hashCode();
    }

    public boolean equals(Object o) {
        return o != null && this.getClass().equals(o.getClass()) && this.node().equals(((MetaStructureObject)o).node());
    }
}

