/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.neometa.structure;

import java.util.Collection;
import org.neo4j.api.core.Direction;
import org.neo4j.api.core.Node;
import org.neo4j.api.core.Relationship;
import org.neo4j.api.core.RelationshipType;
import org.neo4j.api.core.Transaction;
import org.neo4j.neometa.structure.MetaStructure;
import org.neo4j.neometa.structure.MetaStructureClass;
import org.neo4j.neometa.structure.MetaStructureObjectCollection;
import org.neo4j.neometa.structure.MetaStructureRelTypes;
import org.neo4j.neometa.structure.MetaStructureRestrictable;
import org.neo4j.neometa.structure.MetaStructureThing;
import org.neo4j.neometa.structure.PropertyRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaStructureProperty
extends MetaStructureThing
implements MetaStructureRestrictable {
    public MetaStructureProperty(MetaStructure meta, Node node) {
        super(meta, node);
    }

    private Collection<MetaStructureProperty> hierarchyCollection(Direction direction) {
        return new MetaStructureObjectCollection<MetaStructureProperty>(this.neo(), this.node(), MetaStructureRelTypes.META_IS_SUBPROPERTY_OF, direction, this.meta(), MetaStructureProperty.class);
    }

    public Collection<MetaStructureProperty> getDirectSubs() {
        return this.hierarchyCollection(Direction.INCOMING);
    }

    public Collection<MetaStructureProperty> getDirectSupers() {
        return this.hierarchyCollection(Direction.OUTGOING);
    }

    @Override
    protected RelationshipType subRelationshipType() {
        return MetaStructureRelTypes.META_IS_SUBPROPERTY_OF;
    }

    public Collection<MetaStructureClass> associatedMetaClasses() {
        return new MetaStructureObjectCollection<MetaStructureClass>(this.neo(), this.node(), MetaStructureRelTypes.META_CLASS_HAS_PROPERTY, Direction.INCOMING, this.meta(), MetaStructureClass.class);
    }

    @Override
    public void setRange(PropertyRange range) {
        PropertyRange.setOrRemoveRange(this, range);
    }

    @Override
    public PropertyRange getRange() {
        return PropertyRange.loadRange(this);
    }

    @Override
    public void setMinCardinality(Integer cardinalityOrNull) {
        this.setOrRemoteProperty("min_cardinality", cardinalityOrNull);
    }

    @Override
    public Integer getMinCardinality() {
        return (Integer)this.getProperty("min_cardinality", null);
    }

    @Override
    public void setMaxCardinality(Integer cardinalityOrNull) {
        this.setOrRemoteProperty("max_cardinality", cardinalityOrNull);
    }

    @Override
    public Integer getMaxCardinality() {
        return (Integer)this.getProperty("max_cardinality", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCardinality(Integer cardinality) {
        Transaction tx = this.neo().beginTx();
        try {
            this.setMinCardinality(cardinality);
            this.setMaxCardinality(cardinality);
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    @Override
    public void setCollectionBehaviourClass(Class<? extends Collection> collectionClassOrNull) {
        this.setOrRemoteProperty("collection_class", collectionClassOrNull == null ? null : collectionClassOrNull.getName());
    }

    @Override
    public Class<? extends Collection<?>> getCollectionBehaviourClass() {
        try {
            String className = (String)this.getProperty("collection_class", null);
            return className == null ? null : Class.forName(className);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setInverseOf(MetaStructureProperty propertyOrNull) {
        this.setSingleRelationshipOrNull(propertyOrNull == null ? null : propertyOrNull.node(), MetaStructureRelTypes.META_IS_INVERSE_OF);
    }

    public MetaStructureProperty getInverseOf() {
        Relationship rel = this.getSingleRelationshipOrNull(MetaStructureRelTypes.META_IS_INVERSE_OF);
        return rel == null ? null : new MetaStructureProperty(this.meta(), rel.getOtherNode(this.node()));
    }
}

