/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.neometa.structure;

import java.util.Collection;
import org.neo4j.api.core.Direction;
import org.neo4j.api.core.Node;
import org.neo4j.api.core.RelationshipType;
import org.neo4j.api.core.Transaction;
import org.neo4j.neometa.structure.MetaStructure;
import org.neo4j.neometa.structure.MetaStructureClass;
import org.neo4j.neometa.structure.MetaStructureObject;
import org.neo4j.neometa.structure.MetaStructureProperty;
import org.neo4j.neometa.structure.MetaStructureRelTypes;
import org.neo4j.neometa.structure.MetaStructureRestrictable;
import org.neo4j.neometa.structure.PropertyRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaStructureRestriction
extends MetaStructureObject
implements MetaStructureRestrictable {
    public MetaStructureRestriction(MetaStructure meta, Node node) {
        super(meta, node);
    }

    public MetaStructureClass getMetaClass() {
        return new MetaStructureClass(this.meta(), this.neoUtil().getSingleOtherNode(this.node(), (RelationshipType)MetaStructureRelTypes.META_RESTRICTION_TO_CLASS, Direction.OUTGOING));
    }

    public MetaStructureProperty getMetaProperty() {
        return new MetaStructureProperty(this.meta(), this.neoUtil().getSingleOtherNode(this.node(), (RelationshipType)MetaStructureRelTypes.META_RESTRICTION_TO_PROPERTY, Direction.OUTGOING));
    }

    @Override
    public void setRange(PropertyRange range) {
        PropertyRange.setOrRemoveRange(this, range);
    }

    @Override
    public PropertyRange getRange() {
        return PropertyRange.loadRange(this);
    }

    @Override
    public void setMinCardinality(Integer cardinalityOrNull) {
        this.setOrRemoteProperty("min_cardinality", cardinalityOrNull);
    }

    @Override
    public Integer getMinCardinality() {
        return (Integer)this.getProperty("min_cardinality", null);
    }

    @Override
    public void setMaxCardinality(Integer cardinalityOrNull) {
        this.setOrRemoteProperty("max_cardinality", cardinalityOrNull);
    }

    @Override
    public Integer getMaxCardinality() {
        return (Integer)this.getProperty("max_cardinality", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCardinality(Integer cardinality) {
        Transaction tx = this.neo().beginTx();
        try {
            this.setMinCardinality(cardinality);
            this.setMaxCardinality(cardinality);
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    @Override
    public void setCollectionBehaviourClass(Class<? extends Collection> collectionClassOrNull) {
        this.setOrRemoteProperty("collection_class", collectionClassOrNull == null ? null : collectionClassOrNull.getName());
    }

    @Override
    public Class<? extends Collection<?>> getCollectionBehaviourClass() {
        try {
            String className = (String)this.getProperty("collection_class", null);
            return className == null ? null : Class.forName(className);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

