/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.neometa.structure;

import java.util.Collection;
import org.neo4j.api.core.Direction;
import org.neo4j.api.core.Node;
import org.neo4j.api.core.RelationshipType;
import org.neo4j.api.core.ReturnableEvaluator;
import org.neo4j.api.core.StopEvaluator;
import org.neo4j.api.core.Transaction;
import org.neo4j.api.core.Traverser;
import org.neo4j.neometa.structure.MetaStructure;
import org.neo4j.neometa.structure.MetaStructureObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MetaStructureThing
extends MetaStructureObject {
    MetaStructureThing(MetaStructure meta, Node node) {
        super(meta, node);
    }

    public abstract Collection<? extends MetaStructureThing> getDirectSubs();

    public abstract Collection<? extends MetaStructureThing> getDirectSupers();

    protected abstract RelationshipType subRelationshipType();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends MetaStructureThing> boolean isSubOf(T thing) {
        Transaction tx = this.neo().beginTx();
        try {
            boolean found = false;
            Node target = thing.node();
            for (Node node : this.node().traverse(Traverser.Order.BREADTH_FIRST, StopEvaluator.END_OF_NETWORK, ReturnableEvaluator.ALL, this.subRelationshipType(), Direction.OUTGOING)) {
                if (!node.equals(target)) continue;
                found = true;
                break;
            }
            tx.success();
            boolean bl = found;
            return bl;
        }
        finally {
            tx.finish();
        }
    }

    private String additionalPropertyKey(String key) {
        return "additional." + key;
    }

    public void setAdditionalProperty(String key, String value) {
        this.setProperty(this.additionalPropertyKey(key), value);
    }

    public void removeAdditionalProperty(String key) {
        this.removeProperty(this.additionalPropertyKey(key));
    }

    public String getAdditionalProperty(String key) {
        return (String)this.getProperty(this.additionalPropertyKey(key), null);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getName() + "]";
    }
}

