/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.neometa.structure;

import java.text.ParseException;
import org.neo4j.api.core.NeoService;
import org.neo4j.api.core.Transaction;
import org.neo4j.neometa.structure.MetaStructure;
import org.neo4j.neometa.structure.MetaStructureImpl;
import org.neo4j.neometa.structure.MetaStructureRestrictable;

public abstract class PropertyRange {
    static final String KEY_RANGE_IMPL = "range_implementation_class";
    private MetaStructureRestrictable owner;

    protected MetaStructureRestrictable getOwner() {
        return this.owner;
    }

    private static NeoService neo(MetaStructure meta) {
        return ((MetaStructureImpl)meta).neo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void store(MetaStructureRestrictable owner) {
        this.owner = owner;
        Transaction tx = PropertyRange.neo(owner.meta()).beginTx();
        try {
            PropertyRange.removeRange(owner);
            owner.node().setProperty(KEY_RANGE_IMPL, (Object)this.getClass().getName());
            this.internalStore(owner);
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    protected static void removeRange(MetaStructureRestrictable owner) {
        PropertyRange range = PropertyRange.loadRange(owner);
        if (range != null) {
            owner.node().removeProperty(KEY_RANGE_IMPL);
            range.internalRemove(owner);
        }
    }

    protected abstract void internalStore(MetaStructureRestrictable var1);

    protected abstract void internalRemove(MetaStructureRestrictable var1);

    protected abstract void internalLoad(MetaStructureRestrictable var1);

    protected static PropertyRange loadRange(MetaStructureRestrictable owner) {
        Transaction tx = PropertyRange.neo(owner.meta()).beginTx();
        try {
            String rangeType = (String)owner.node().getProperty(KEY_RANGE_IMPL, null);
            if (rangeType == null) {
                PropertyRange propertyRange = null;
                return propertyRange;
            }
            Class<?> cls = Class.forName(rangeType);
            PropertyRange result = (PropertyRange)cls.newInstance();
            result.owner = owner;
            result.internalLoad(owner);
            tx.success();
            PropertyRange propertyRange = result;
            return propertyRange;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void setOrRemoveRange(MetaStructureRestrictable owner, PropertyRange range) {
        Transaction tx = PropertyRange.neo(owner.meta()).beginTx();
        try {
            PropertyRange.removeRange(owner);
            if (range != null) {
                range.store(owner);
            }
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    public abstract Object rdfLiteralToJavaObject(String var1) throws ParseException;

    public abstract String javaObjectToRdfLiteral(Object var1);

    public abstract boolean isDatatype();
}

