/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.neometa.structure;

import java.text.ParseException;
import org.neo4j.neometa.structure.MetaStructureRestrictable;
import org.neo4j.neometa.structure.RdfUtil;
import org.neo4j.neometa.structure.SimpleStringPropertyRange;

public class RdfDatatypeRange
extends SimpleStringPropertyRange {
    private String datatype;

    public RdfDatatypeRange(String datatype) {
        this.datatype = datatype;
    }

    public RdfDatatypeRange() {
    }

    public String getRdfDatatype() {
        return this.datatype;
    }

    protected String toStringRepresentation(MetaStructureRestrictable owner) {
        return this.datatype;
    }

    protected void fromStringRepresentation(MetaStructureRestrictable owner, String stringRepresentation) {
        this.datatype = stringRepresentation;
    }

    private RdfUtil.ValueConverter getConverter() {
        return RdfUtil.getDatatypeConverter(this.getRdfDatatype());
    }

    public Object rdfLiteralToJavaObject(String value) throws ParseException {
        return this.getConverter().convert(value);
    }

    public String javaObjectToRdfLiteral(Object value) {
        return this.getConverter().convertToString(value);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getRdfDatatype() + "]";
    }
}

