/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.neometa.structure;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.neometa.structure.XmlSchemaDateFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RdfUtil {
    public static final String NS_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema#";
    private static Map<String, ValueConverter> datatypePropertyTypes = new HashMap<String, ValueConverter>();

    public static boolean recognizesDatatype(String rdfDatatypeUri) {
        return datatypePropertyTypes.containsKey(rdfDatatypeUri);
    }

    public static ValueConverter getDatatypeConverter(String rdfDatatypeUri) {
        ValueConverter converter = datatypePropertyTypes.get(rdfDatatypeUri);
        if (converter == null) {
            throw new RuntimeException("Unrecognized data type uri " + rdfDatatypeUri);
        }
        return converter;
    }

    public static Object getRealValue(String rdfDatatypeUri, String value) throws ParseException {
        return RdfUtil.getDatatypeConverter(rdfDatatypeUri).convert(value);
    }

    public static String getStringValue(String rdfDatatypeUri, Object value) {
        return RdfUtil.getDatatypeConverter(rdfDatatypeUri).convertToString(value);
    }

    public static Class<?> getDatatypeClass(String rdfDatatypeUri) {
        return RdfUtil.getDatatypeConverter(rdfDatatypeUri).getDatatype();
    }

    static {
        datatypePropertyTypes.put("http://www.w3.org/2001/XMLSchema#string", new NormalConverter(String.class));
        datatypePropertyTypes.put("http://www.w3.org/2001/XMLSchema#normalizedString", new NormalConverter(String.class));
        datatypePropertyTypes.put("http://www.w3.org/2001/XMLSchema#boolean", new BooleanConverter());
        datatypePropertyTypes.put("http://www.w3.org/2001/XMLSchema#byte", new NormalConverter(Byte.class));
        datatypePropertyTypes.put("http://www.w3.org/2001/XMLSchema#unsignedByte", new NormalConverter(Byte.class));
        datatypePropertyTypes.put("http://www.w3.org/2001/XMLSchema#short", new NormalConverter(Short.class));
        datatypePropertyTypes.put("http://www.w3.org/2001/XMLSchema#unsignedShort", new NormalConverter(Short.class));
        datatypePropertyTypes.put("http://www.w3.org/2001/XMLSchema#int", new NormalConverter(Integer.class));
        datatypePropertyTypes.put("http://www.w3.org/2001/XMLSchema#unsignedInt", new NormalConverter(Integer.class));
        datatypePropertyTypes.put("http://www.w3.org/2001/XMLSchema#integer", new NormalConverter(Integer.class));
        datatypePropertyTypes.put("http://www.w3.org/2001/XMLSchema#nonNegativeInteger", new NormalConverter(Integer.class));
        datatypePropertyTypes.put("http://www.w3.org/2001/XMLSchema#positiveInteger", new NormalConverter(Integer.class));
        datatypePropertyTypes.put("http://www.w3.org/2001/XMLSchema#nonPositiveInteger", new NormalConverter(Integer.class));
        datatypePropertyTypes.put("http://www.w3.org/2001/XMLSchema#negativeInteger", new NormalConverter(Integer.class));
        datatypePropertyTypes.put("http://www.w3.org/2001/XMLSchema#long", new NormalConverter(Long.class));
        datatypePropertyTypes.put("http://www.w3.org/2001/XMLSchema#unsignedLong", new NormalConverter(Long.class));
        datatypePropertyTypes.put("http://www.w3.org/2001/XMLSchema#float", new NormalConverter(Float.class));
        datatypePropertyTypes.put("http://www.w3.org/2001/XMLSchema#double", new NormalConverter(Double.class));
        datatypePropertyTypes.put("http://www.w3.org/2001/XMLSchema#decimal", new NormalConverter(Double.class));
        datatypePropertyTypes.put("http://www.w3.org/2001/XMLSchema#gMonthDay", new DateConverter(new SimpleDateFormat("MM-dd")));
        datatypePropertyTypes.put("http://www.w3.org/2001/XMLSchema#gDay", new DateConverter(new SimpleDateFormat("dd")));
        datatypePropertyTypes.put("http://www.w3.org/2001/XMLSchema#gYear", new DateConverter(new SimpleDateFormat("yyyy")));
        datatypePropertyTypes.put("http://www.w3.org/2001/XMLSchema#gMonth", new DateConverter(new SimpleDateFormat("yyyy-MM")));
        datatypePropertyTypes.put("http://www.w3.org/2001/XMLSchema#gYearMonth", new DateConverter(new SimpleDateFormat("yyyy-MM")));
        datatypePropertyTypes.put("http://www.w3.org/2001/XMLSchema#dateTime", new DateConverter(new XmlSchemaDateFormat()));
        datatypePropertyTypes.put("http://www.w3.org/2001/XMLSchema#date", new DateConverter(new SimpleDateFormat("yyyy-MM-dd")));
        datatypePropertyTypes.put("http://www.w3.org/2001/XMLSchema#time", new TimeConverter());
        datatypePropertyTypes = Collections.unmodifiableMap(datatypePropertyTypes);
    }

    private static class TimeConverter
    extends DateConverter {
        private static String timeFormat = "HH:mm:ss";
        private DateFormat withMillis = new SimpleDateFormat(timeFormat + ".SSS");

        TimeConverter() {
            super(new SimpleDateFormat("HH:mm:ss"));
        }

        public Object convert(String value) throws ParseException {
            return value.length() == timeFormat.length() ? super.convert(value) : this.withMillis.parse(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DateConverter
    extends ValueConverter {
        private DateFormat format;

        DateConverter(DateFormat format) {
            this.format = format;
        }

        @Override
        public Object convert(String value) throws ParseException {
            return this.format.parse(value);
        }

        @Override
        public String convertToString(Object value) {
            Date date = (Date)value;
            return this.format.format(date);
        }

        @Override
        public Class<?> getDatatype() {
            return Date.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BooleanConverter
    extends ValueConverter {
        private BooleanConverter() {
        }

        @Override
        public Object convert(String value) throws ParseException {
            if (!value.equals(Boolean.TRUE.toString()) && !value.equals(Boolean.FALSE.toString())) {
                throw new ParseException("Invalid boolean value '" + value + "'", 0);
            }
            return Boolean.parseBoolean(value);
        }

        @Override
        public String convertToString(Object value) {
            return value.toString();
        }

        @Override
        public Class<?> getDatatype() {
            return Boolean.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NormalConverter
    extends ValueConverter {
        private Class<?> cls;

        NormalConverter(Class<?> cls) {
            this.cls = cls;
        }

        @Override
        public Object convert(String value) throws ParseException {
            try {
                return this.cls.getConstructor(String.class).newInstance(value);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public String convertToString(Object value) {
            return value.toString();
        }

        @Override
        public Class<?> getDatatype() {
            return this.cls;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ValueConverter {
        public abstract Object convert(String var1) throws ParseException;

        public abstract String convertToString(Object var1);

        public abstract Class<?> getDatatype();
    }
}

