/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.neometa.structure;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class XmlSchemaDateFormat
extends DateFormat {
    private static final DateFormat DATEFORMAT_XSD_ZULU = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");

    public Date parse(String src, ParsePosition position) {
        Date date = null;
        int index = 0;
        try {
            if (src != null) {
                if (src.charAt(0) == '+' || src.charAt(0) == '-') {
                    src = src.substring(1);
                }
                if (src.length() < 19) {
                    position.setIndex(src.length() - 1);
                    this.handleParseError(position, "TOO_FEW_CHARS");
                }
                index = 4;
                this.validateChar(src, position, 4, '-', "EXPECTED_DASH");
                index = 7;
                this.validateChar(src, position, 7, '-', "EXPECTED_DASH");
                index = 10;
                this.validateChar(src, position, 10, 'T', "EXPECTED_CAPITAL_T");
                index = 13;
                this.validateChar(src, position, 13, ':', "EXPECTED_COLON_IN_TIME");
                index = 16;
                this.validateChar(src, position, 16, ':', "EXPECTED_COLON_IN_TIME");
            }
            try {
                date = DATEFORMAT_XSD_ZULU.parse(src == null ? null : src.substring(0, 19) + ".000Z");
            }
            catch (Exception e) {
                throw new NumberFormatException(e.toString());
            }
            index = 19;
            if (src != null) {
                if (index < src.length() && src.charAt(index) == '.') {
                    int milliseconds = 0;
                    int start = ++index;
                    while (index < src.length() && Character.isDigit(src.charAt(index))) {
                        ++index;
                    }
                    String decimal = src.substring(start, index);
                    if (decimal.length() == 3) {
                        milliseconds = Integer.parseInt(decimal);
                    } else if (decimal.length() < 3) {
                        milliseconds = Integer.parseInt((decimal + "000").substring(0, 3));
                    } else {
                        milliseconds = Integer.parseInt(decimal.substring(0, 3));
                        if (decimal.charAt(3) >= '5') {
                            ++milliseconds;
                        }
                    }
                    date.setTime(date.getTime() + (long)milliseconds);
                }
                if (index + 5 < src.length() && (src.charAt(index) == '+' || src.charAt(index) == '-')) {
                    this.validateCharIsDigit(src, position, index + 1, "EXPECTED_NUMERAL");
                    this.validateCharIsDigit(src, position, index + 2, "EXPECTED_NUMERAL");
                    this.validateChar(src, position, index + 3, ':', "EXPECTED_COLON_IN_TIMEZONE");
                    this.validateCharIsDigit(src, position, index + 4, "EXPECTED_NUMERAL");
                    this.validateCharIsDigit(src, position, index + 5, "EXPECTED_NUMERAL");
                    int hours = (src.charAt(index + 1) - 48) * 10 + src.charAt(index + 2) - 48;
                    int mins = (src.charAt(index + 4) - 48) * 10 + src.charAt(index + 5) - 48;
                    int millisecs = (hours * 60 + mins) * 60 * 1000;
                    if (src.charAt(index) == '+') {
                        millisecs = -millisecs;
                    }
                    date.setTime(date.getTime() + (long)millisecs);
                    index += 6;
                }
                if (index < src.length() && src.charAt(index) == 'Z') {
                    ++index;
                }
                if (index < src.length()) {
                    this.handleParseError(position, "TOO_MANY_CHARS");
                }
            }
        }
        catch (ParseException pe) {
            index = 0;
            position.setErrorIndex(index);
            date = null;
        }
        position.setIndex(index);
        return date;
    }

    public StringBuffer format(Date date, StringBuffer buffer, FieldPosition position) {
        String str = DATEFORMAT_XSD_ZULU.format(date);
        if (buffer == null) {
            buffer = new StringBuffer();
        }
        buffer.append(str);
        return buffer;
    }

    private void validateChar(String str, ParsePosition parse_pos, int index, char expected, String erorrReason) throws ParseException {
        if (str.charAt(index) != expected) {
            this.handleParseError(parse_pos, erorrReason);
        }
    }

    private void validateCharIsDigit(String str, ParsePosition position, int index, String errorReason) throws ParseException {
        if (!Character.isDigit(str.charAt(index))) {
            this.handleParseError(position, errorReason);
        }
    }

    private void handleParseError(ParsePosition position, String errorReason) throws ParseException {
        throw new ParseException("INVALID_XSD_DATETIME", position.getErrorIndex());
    }

    static {
        DATEFORMAT_XSD_ZULU.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

