/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rdf.sail;

import info.aduna.iteration.CloseableIteration;
import java.util.Iterator;
import java.util.LinkedList;
import org.neo4j.api.core.NeoService;
import org.neo4j.api.core.Node;
import org.neo4j.api.core.Transaction;
import org.openrdf.model.Namespace;
import org.openrdf.model.impl.NamespaceImpl;
import org.openrdf.sail.SailException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NeoNamespaceIteration
implements CloseableIteration<Namespace, SailException> {
    private final Iterator<Namespace> iterator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NeoNamespaceIteration(Node node, NeoService neo) {
        Transaction tx = neo.beginTx();
        try {
            LinkedList<NamespaceImpl> namespaces = new LinkedList<NamespaceImpl>();
            for (String key : node.getPropertyKeys()) {
                String uri = (String)node.getProperty(key);
                namespaces.add(new NamespaceImpl(key, uri));
            }
            this.iterator = namespaces.iterator();
        }
        finally {
            tx.finish();
        }
    }

    public void close() throws SailException {
    }

    public boolean hasNext() throws SailException {
        return this.iterator.hasNext();
    }

    public Namespace next() throws SailException {
        return this.iterator.next();
    }

    public void remove() throws SailException {
    }
}

