/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rdf.sail;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.api.core.NeoService;
import org.neo4j.rdf.sail.NeoSailConnection;
import org.neo4j.rdf.sail.utils.MutatingLogger;
import org.neo4j.rdf.store.RdfStore;
import org.neo4j.rdf.util.TemporaryLogger;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.sail.Sail;
import org.openrdf.sail.SailChangedListener;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;

public class NeoSail
implements Sail {
    private static final boolean IS_WRITABLE = true;
    private final NeoService neo;
    private final RdfStore store;
    private final ValueFactory valueFactory = new ValueFactoryImpl();
    private final Set<SailChangedListener> listeners = new HashSet<SailChangedListener>();
    private final AtomicInteger connectionCounter = new AtomicInteger();
    private final Map<Integer, NeoSailConnection> activeConnections = Collections.synchronizedMap(new HashMap());

    public NeoSail(NeoService neo, RdfStore store) {
        this.neo = neo;
        this.store = store;
    }

    public void setDataDir(File file) {
    }

    public File getDataDir() {
        return null;
    }

    public void initialize() throws SailException {
    }

    public void shutDown() throws SailException {
        TemporaryLogger.getLogger().info((Object)(this.getClass().getName() + " shutDown called"), (Throwable)new Exception());
        this.printActiveConnections();
        this.store.shutDown();
    }

    private void printActiveConnections() {
        for (Map.Entry<Integer, NeoSailConnection> entry : this.activeConnections.entrySet()) {
            String logString = "NeoSailConnection[" + entry.getKey() + "] still open when shutting down sail, closing";
            TemporaryLogger.getLogger().warn((Object)logString);
            MutatingLogger.getLogger().warn((Object)logString);
            try {
                entry.getValue().close();
            }
            catch (Exception e) {
                TemporaryLogger.getLogger().warn((Object)e);
                MutatingLogger.getLogger().warn((Object)e);
            }
        }
    }

    public boolean isWritable() throws SailException {
        return true;
    }

    public SailConnection getConnection() throws SailException {
        this.connectionCounter.incrementAndGet();
        NeoSailConnection connection = new NeoSailConnection(this.neo, this.store, this, this.valueFactory, this.listeners);
        this.activeConnections.put(connection.getIdentifier(), connection);
        return connection;
    }

    void connectionEnded(int identifier, NeoSailConnection connection) {
        this.activeConnections.remove(identifier);
    }

    public ValueFactory getValueFactory() {
        return this.valueFactory;
    }

    public void addSailChangedListener(SailChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removeSailChangedListener(SailChangedListener listener) {
        this.listeners.remove(listener);
    }
}

