/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rdf.sail;

import info.aduna.iteration.CloseableIteration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.neo4j.api.core.EmbeddedNeo;
import org.neo4j.api.core.NeoService;
import org.neo4j.api.core.Node;
import org.neo4j.api.core.RelationshipType;
import org.neo4j.commons.iterator.CombiningIterable;
import org.neo4j.impl.transaction.DeadlockDetectedException;
import org.neo4j.rdf.fulltext.FulltextIndex;
import org.neo4j.rdf.model.CompleteStatement;
import org.neo4j.rdf.model.StatementMetadata;
import org.neo4j.rdf.model.WildcardStatement;
import org.neo4j.rdf.sail.FulltextQueryResult;
import org.neo4j.rdf.sail.NeoNamespaceIteration;
import org.neo4j.rdf.sail.NeoRdfSailConnection;
import org.neo4j.rdf.sail.NeoSail;
import org.neo4j.rdf.sail.NeoSesameMapper;
import org.neo4j.rdf.sail.NeoStatementIteration;
import org.neo4j.rdf.sail.QueryResultIteration;
import org.neo4j.rdf.sail.SesameNeoMapper;
import org.neo4j.rdf.sail.utils.ContextHandling;
import org.neo4j.rdf.sail.utils.MutatingLogger;
import org.neo4j.rdf.sail.utils.SailConnectionTripleSource;
import org.neo4j.rdf.store.RdfStore;
import org.neo4j.rdf.store.RdfStoreImpl;
import org.neo4j.rdf.util.TemporaryLogger;
import org.neo4j.util.NeoUtil;
import org.openrdf.model.Literal;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.evaluation.TripleSource;
import org.openrdf.query.algebra.evaluation.impl.EvaluationStrategyImpl;
import org.openrdf.sail.Sail;
import org.openrdf.sail.SailChangedEvent;
import org.openrdf.sail.SailChangedListener;
import org.openrdf.sail.SailConnectionListener;
import org.openrdf.sail.SailException;
import org.openrdf.sail.helpers.DefaultSailChangedEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NeoSailConnection
implements NeoRdfSailConnection {
    private static final int DEFAULT_BATCHSIZE = 5000;
    private static final int NUMBER_OF_RETRIES = 5;
    private static final AtomicInteger connectionIdentifier = new AtomicInteger(0);
    private final NeoService neo;
    private final TransactionManager tm;
    private final RdfStore store;
    private final ValueFactory valueFactory;
    private final Set<SailConnectionListener> sailConnectionListeners = new HashSet<SailConnectionListener>();
    private final Collection<SailChangedListener> sailChangedListeners;
    private final int batchSize;
    private Transaction transaction;
    private boolean open;
    private final AtomicInteger writeOperationCount = new AtomicInteger();
    private final Sail sail;
    private final AtomicInteger totalAddCount = new AtomicInteger();
    private final List<Command> commands = new ArrayList<Command>();
    private final int identifier;

    NeoSailConnection(NeoService neo, RdfStore store, Sail sail, ValueFactory valueFactory, Collection<SailChangedListener> sailChangedListeners) {
        this(neo, store, sail, valueFactory, 5000, sailChangedListeners);
    }

    NeoSailConnection(NeoService neo, RdfStore store, Sail sail, ValueFactory valueFactory, int batchSize, Collection<SailChangedListener> sailChangedListeners) {
        this.neo = neo;
        this.store = store;
        this.sail = sail;
        this.valueFactory = valueFactory;
        this.open = true;
        this.batchSize = batchSize;
        this.sailChangedListeners = sailChangedListeners;
        this.tm = ((EmbeddedNeo)neo).getConfig().getTxModule().getTxManager();
        this.identifier = connectionIdentifier.incrementAndGet();
        this.log("connection created");
    }

    int getIdentifier() {
        return this.identifier;
    }

    private void log(String msg) {
        if (this.transaction != null) {
            MutatingLogger.getLogger().info((Object)("NeoSailConnection[" + this.identifier + "] running with tx[" + this.transaction.hashCode() + "]: " + msg));
        } else {
            MutatingLogger.getLogger().info((Object)("NeoSailConnection[" + this.identifier + "] running with tx[" + null + "]: " + msg));
        }
    }

    private void beginTransaction() {
        try {
            this.tm.begin();
            this.transaction = this.tm.getTransaction();
            if (this.transaction == null) {
                System.out.println("GAHHHHHHH");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    Transaction suspendOtherAndResumeThis() {
        try {
            Transaction otherTx = this.tm.getTransaction();
            if (otherTx != null && otherTx == this.transaction) {
                return null;
            }
            if (otherTx != null) {
                this.tm.suspend();
            }
            if (this.transaction == null) {
                this.beginTransaction();
            } else {
                this.tm.resume(this.transaction);
            }
            return otherTx;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    void suspendThisAndResumeOther(Transaction otherTx) {
        try {
            this.tm.suspend();
            if (otherTx != null) {
                this.tm.resume(otherTx);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private void resumeOther(Transaction otherTx) {
        try {
            if (otherTx != null) {
                this.tm.resume(otherTx);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized boolean isOpen() throws SailException {
        return this.open;
    }

    public synchronized void close() throws SailException {
        if (!this.open) {
            return;
        }
        this.open = false;
        if (this.commands.size() != 0) {
            this.log("close(): there are " + this.commands.size() + " non commited operations that will be rolled back on close");
        }
        this.commands.clear();
        Transaction otherTx = this.suspendOtherAndResumeThis();
        try {
            this.tm.rollback();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        finally {
            this.log("connection closed");
            ((NeoSail)this.sail).connectionEnded(this.identifier, this);
            this.transaction = null;
            if (otherTx != null) {
                this.resumeOther(otherTx);
            }
        }
    }

    public CloseableIteration<? extends BindingSet, QueryEvaluationException> evaluate(TupleExpr tupleExpr, Dataset dataset, BindingSet bindingSet, boolean includeInferred) throws SailException {
        try {
            SailConnectionTripleSource tripleSource = new SailConnectionTripleSource(this, this.valueFactory, includeInferred);
            EvaluationStrategyImpl strategy = new EvaluationStrategyImpl((TripleSource)tripleSource, dataset);
            return strategy.evaluate(tupleExpr, bindingSet);
        }
        catch (QueryEvaluationException e) {
            throw new SailException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CloseableIteration<FulltextQueryResult, SailException> evaluate(String query) {
        Transaction otherTx = this.suspendOtherAndResumeThis();
        try {
            Iterable queryResult = this.store.searchFulltext(query);
            QueryResultIteration queryResultIteration = new QueryResultIteration(queryResult.iterator(), this);
            return queryResultIteration;
        }
        finally {
            this.suspendThisAndResumeOther(otherTx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CloseableIteration<FulltextQueryResult, SailException> evaluateWithSnippets(String query, int snippetCountLimit) {
        Transaction otherTx = this.suspendOtherAndResumeThis();
        try {
            Iterable queryResult = this.store.searchFulltextWithSnippets(query, snippetCountLimit);
            QueryResultIteration queryResultIteration = new QueryResultIteration(queryResult.iterator(), this);
            return queryResultIteration;
        }
        finally {
            this.suspendThisAndResumeOther(otherTx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void reindexFulltextIndex() {
        this.log("reindexFulltextIndex() called");
        Transaction otherTx = this.suspendOtherAndResumeThis();
        try {
            FulltextIndex fulltextIndex = ((RdfStoreImpl)this.store).getFulltextIndex();
            if (fulltextIndex == null) {
                throw new RuntimeException("Fulltext index not used, please supply it in the RdfStore constructor");
            }
            ((RdfStoreImpl)this.store).reindexFulltextIndex();
            this.log("reindexFulltextIndex() completed");
        }
        finally {
            this.suspendThisAndResumeOther(otherTx);
        }
    }

    public CloseableIteration<? extends Resource, SailException> getContextIDs() throws SailException {
        return null;
    }

    protected synchronized Iterator<CompleteStatement> getNeoRdfStatements(Resource subject, URI predicate, Value object, boolean includeInferred, Resource ... contexts) throws SailException {
        if (includeInferred) {
            includeInferred = false;
        }
        try {
            Iterable result = null;
            if (contexts.length == 0) {
                Iterable iterator;
                WildcardStatement statement = SesameNeoMapper.createWildcardStatement(subject, predicate, object, new Resource[0]);
                result = iterator = this.store.getStatements(statement, includeInferred);
            } else {
                LinkedList<Iterable> allQueries = new LinkedList<Iterable>();
                for (Resource context : contexts) {
                    WildcardStatement statement = SesameNeoMapper.createWildcardStatement(subject, predicate, object, context);
                    Iterable iterator = this.store.getStatements(statement, includeInferred);
                    allQueries.add(iterator);
                }
                result = new CombiningIterable(allQueries);
            }
            return result.iterator();
        }
        catch (RuntimeException e) {
            throw new SailException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CloseableIteration<? extends Statement, SailException> getStatements(Resource subject, URI predicate, Value object, boolean includeInferred, Resource ... contexts) throws SailException {
        Transaction otherTx = this.suspendOtherAndResumeThis();
        try {
            NeoStatementIteration neoStatementIteration = new NeoStatementIteration(this.getNeoRdfStatements(subject, predicate, object, includeInferred, contexts), this);
            return neoStatementIteration;
        }
        finally {
            this.suspendThisAndResumeOther(otherTx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long size(Resource ... contexts) throws SailException {
        Transaction otherTx = this.suspendOtherAndResumeThis();
        try {
            long l = this.store.size(ContextHandling.createContexts(contexts));
            return l;
        }
        finally {
            this.suspendThisAndResumeOther(otherTx);
        }
    }

    private void innerAddStatement(Resource subject, URI predicate, Value object, Resource ... contexts) throws SailException {
        this.commands.add(new Command(CommandType.ADD_STATEMENT, subject, predicate, object, contexts));
        try {
            this.internalAddStatement(subject, predicate, object, contexts);
            this.totalAddCount.incrementAndGet();
            this.checkBatchCommit();
        }
        catch (DeadlockDetectedException e) {
            this.handleDeadlockDetected(e);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw new SailException((Throwable)e);
        }
    }

    private String spogString(Resource subject, URI predicate, Value object, Resource ... contexts) {
        StringBuffer spog = new StringBuffer("S[");
        spog.append(subject).append("] P[").append(predicate).append("] O[").append(object).append("] G[");
        for (Resource r : contexts) {
            spog.append("[" + r + "]");
        }
        spog.append("]");
        return spog.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addStatement(Resource subject, URI predicate, Value object, Resource ... contexts) throws SailException {
        Transaction otherTx = this.suspendOtherAndResumeThis();
        try {
            this.log("addStatement: " + this.spogString(subject, predicate, object, contexts));
            this.innerAddStatement(subject, predicate, object, contexts);
        }
        finally {
            this.suspendThisAndResumeOther(otherTx);
        }
        this.sendEventsToListeners(subject, predicate, object, contexts);
    }

    private void sendEventsToListeners(Resource subject, URI predicate, Value object, Resource ... contexts) {
        if (this.sailConnectionListeners.size() > 0) {
            for (SailConnectionListener l : this.sailConnectionListeners) {
                if (0 == contexts.length) {
                    l.statementAdded(this.valueFactory.createStatement(subject, predicate, object));
                    continue;
                }
                for (Resource context : contexts) {
                    l.statementAdded(this.valueFactory.createStatement(subject, predicate, object, context));
                }
            }
        }
        if (this.sailChangedListeners.size() > 0) {
            DefaultSailChangedEvent event = new DefaultSailChangedEvent(this.sail);
            event.setStatementsAdded(true);
            for (SailChangedListener listener : this.sailChangedListeners) {
                listener.sailChanged((SailChangedEvent)event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Statement addStatement(Map<String, Literal> metadata, Resource subject, URI predicate, Value object, Resource ... contexts) throws SailException {
        Statement result = null;
        Transaction otherTx = this.suspendOtherAndResumeThis();
        try {
            this.log("addStatement with metadata: " + this.spogString(subject, predicate, object, contexts));
            this.innerAddStatement(subject, predicate, object, contexts);
            CompleteStatement statement = this.getNeoRdfStatements(subject, predicate, object, false, contexts).next();
            this.setStatementMetadata(statement, metadata);
            result = NeoSesameMapper.createStatement(statement, true);
        }
        finally {
            this.suspendThisAndResumeOther(otherTx);
        }
        this.sendEventsToListeners(subject, predicate, object, contexts);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setStatementMetadata(Statement statement, Map<String, Literal> metadata) throws SailException {
        Transaction otherTx = this.suspendOtherAndResumeThis();
        try {
            this.log("setStatementMetadata: " + statement);
            CompleteStatement neoStatement = this.getNeoRdfStatements(statement.getSubject(), statement.getPredicate(), statement.getObject(), false, statement.getContext()).next();
            this.setStatementMetadata(neoStatement, metadata);
        }
        finally {
            this.suspendThisAndResumeOther(otherTx);
        }
    }

    private void setStatementMetadata(CompleteStatement statement, Map<String, Literal> metadata) throws SailException {
        try {
            HashSet<String> allKeys = new HashSet<String>();
            allKeys.addAll(metadata.keySet());
            StatementMetadata existingMetadata = statement.getMetadata();
            for (String key : existingMetadata.getKeys()) {
                allKeys.add(key);
            }
            for (String key : allKeys) {
                Literal value = metadata.get(key);
                if (value != null && existingMetadata.has(key)) {
                    if (existingMetadata.get(key).equals((Object)value)) continue;
                    existingMetadata.set(key, SesameNeoMapper.createLiteral(value));
                    continue;
                }
                if (value != null) {
                    existingMetadata.set(key, SesameNeoMapper.createLiteral(value));
                    continue;
                }
                existingMetadata.remove(key);
            }
        }
        catch (RuntimeException e) {
            throw new SailException((Throwable)e);
        }
    }

    private void internalAddStatement(Resource subject, URI predicate, Value object, Resource ... contexts) {
        if (contexts.length == 0) {
            CompleteStatement statement = SesameNeoMapper.createCompleteStatement(subject, predicate, object, new Resource[]{null});
            this.store.addStatements(new CompleteStatement[]{statement});
        } else {
            for (Resource context : contexts) {
                CompleteStatement statement = SesameNeoMapper.createCompleteStatement(subject, predicate, object, context);
                this.store.addStatements(new CompleteStatement[]{statement});
            }
        }
    }

    public synchronized void removeStatements(Resource subject, URI predicate, Value object, Resource ... contexts) throws SailException {
        Transaction otherTx = this.suspendOtherAndResumeThis();
        try {
            this.log("removeStatements: " + this.spogString(subject, predicate, object, contexts));
            this.commands.add(new Command(CommandType.REMOVE_STATEMENT, subject, predicate, object, contexts));
            this.internalRemoveStatements(subject, predicate, object, contexts);
            this.checkBatchCommit();
        }
        catch (DeadlockDetectedException e) {
            this.handleDeadlockDetected(e);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw new SailException((Throwable)e);
        }
        finally {
            this.suspendThisAndResumeOther(otherTx);
        }
        if (this.sailChangedListeners.size() > 0) {
            DefaultSailChangedEvent event = new DefaultSailChangedEvent(this.sail);
            event.setStatementsRemoved(true);
            for (SailChangedListener listener : this.sailChangedListeners) {
                listener.sailChanged((SailChangedEvent)event);
            }
        }
    }

    private void internalRemoveStatements(Resource subject, URI predicate, Value object, Resource ... contexts) {
        if (contexts.length == 0) {
            WildcardStatement statement = SesameNeoMapper.createWildcardStatement(subject, predicate, object, new Resource[0]);
            this.store.removeStatements(statement);
        } else {
            for (Resource context : contexts) {
                WildcardStatement statement = SesameNeoMapper.createWildcardStatement(subject, predicate, object, context);
                this.store.removeStatements(statement);
            }
        }
    }

    private void handleDeadlockDetected(DeadlockDetectedException dde) {
        for (int i = 0; i < 5; ++i) {
            try {
                int txId = this.getTxId();
                this.transaction.rollback();
                this.commitFulltextIndex(txId, false);
                this.tm.begin();
                this.transaction = this.tm.getTransaction();
            }
            catch (Exception e) {
                dde.printStackTrace();
                throw new RuntimeException("Problem during rollback/begin transaction handling DDE", e);
            }
            try {
                for (Command c : this.commands) {
                    if (c.getType() == CommandType.ADD_STATEMENT) {
                        this.internalAddStatement(c.getSubject(), c.getPredicate(), c.getObject(), c.getContexts());
                        continue;
                    }
                    if (c.getType() != CommandType.REMOVE_STATEMENT) continue;
                    this.internalRemoveStatements(c.getSubject(), c.getPredicate(), c.getObject(), c.getContexts());
                }
                return;
            }
            catch (DeadlockDetectedException deadlockDetectedException) {
                continue;
            }
        }
        throw new RuntimeException("Failed to handle DDE", dde);
    }

    private void commitFulltextIndex(int txId, boolean commit) {
        FulltextIndex fulltextIndex = ((RdfStoreImpl)this.store).getFulltextIndex();
        if (fulltextIndex != null) {
            fulltextIndex.end(txId, commit);
        }
    }

    private int getTxId() throws Exception {
        return this.transaction.hashCode();
    }

    public synchronized void commit() throws SailException {
        TemporaryLogger.getLogger().info((Object)(this.getClass().getName() + " commit called"));
        Transaction otherTx = this.suspendOtherAndResumeThis();
        try {
            int txId = this.getTxId();
            this.tm.commit();
            this.transaction = null;
            this.commitFulltextIndex(txId, true);
            this.log("commit() called on tx[" + txId + "] " + this.commands.size() + " operations committed");
            this.clearBatchCommit();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        finally {
            this.resumeOther(otherTx);
        }
    }

    public synchronized void rollback() throws SailException {
        Transaction otherTx = this.suspendOtherAndResumeThis();
        try {
            int txId = this.getTxId();
            this.tm.rollback();
            this.commitFulltextIndex(txId, false);
            this.transaction = null;
            this.log("rollback() called on tx[" + txId + "] " + this.commands.size() + " operations rolled back");
            this.clearBatchCommit();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        finally {
            this.resumeOther(otherTx);
        }
    }

    private synchronized void checkBatchCommit() throws SailException {
        if (this.writeOperationCount.incrementAndGet() >= this.batchSize) {
            try {
                int txId = this.getTxId();
                this.tm.commit();
                this.commitFulltextIndex(txId, true);
                this.tm.begin();
                this.transaction = this.tm.getTransaction();
                this.log("<- new tx, old tx[" + txId + "] commited " + this.commands.size() + " operations");
                this.clearBatchCommit();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private synchronized void clearBatchCommit() {
        this.commands.clear();
        this.writeOperationCount.set(0);
    }

    public void clear(Resource ... contexts) throws SailException {
        this.removeStatements(null, null, null, contexts);
    }

    public CloseableIteration<? extends Namespace, SailException> getNamespaces() throws SailException {
        return new NeoNamespaceIteration(this.getNamespaceNode(), this.neo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getNamespace(String prefix) throws SailException {
        Transaction otherTx = this.suspendOtherAndResumeThis();
        try {
            String uri;
            String string = uri = (String)this.getNamespaceNode().getProperty(prefix, null);
            return string;
        }
        finally {
            this.suspendThisAndResumeOther(otherTx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setNamespace(String prefix, String uri) throws SailException {
        Transaction otherTx = this.suspendOtherAndResumeThis();
        try {
            this.getNamespaceNode().setProperty(prefix, (Object)uri);
        }
        finally {
            this.suspendThisAndResumeOther(otherTx);
        }
    }

    private Node getNamespaceNode() {
        return new NeoUtil(this.neo).getOrCreateSubReferenceNode((RelationshipType)NeoSailRelTypes.REF_TO_NAMESPACE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeNamespace(String prefix) throws SailException {
        Transaction otherTx = this.suspendOtherAndResumeThis();
        try {
            this.getNamespaceNode().removeProperty(prefix);
        }
        finally {
            this.suspendThisAndResumeOther(otherTx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clearNamespaces() throws SailException {
        Transaction otherTx = this.suspendOtherAndResumeThis();
        try {
            this.getNamespaceNode().delete();
        }
        finally {
            this.suspendThisAndResumeOther(otherTx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionListener(SailConnectionListener listener) {
        Set<SailConnectionListener> set = this.sailConnectionListeners;
        synchronized (set) {
            this.sailConnectionListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionListener(SailConnectionListener listener) {
        Set<SailConnectionListener> set = this.sailConnectionListeners;
        synchronized (set) {
            this.sailConnectionListeners.remove(listener);
        }
    }

    private static class Command {
        private final CommandType type;
        private final Resource subject;
        private final URI predicate;
        private final Value object;
        private final Resource[] contexts;

        Command(CommandType type, Resource subject, URI predicate, Value object, Resource ... contexts) {
            this.type = type;
            this.subject = subject;
            this.predicate = predicate;
            this.object = object;
            this.contexts = contexts;
        }

        CommandType getType() {
            return this.type;
        }

        Resource getSubject() {
            return this.subject;
        }

        URI getPredicate() {
            return this.predicate;
        }

        Value getObject() {
            return this.object;
        }

        Resource[] getContexts() {
            return this.contexts;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CommandType {
        ADD_STATEMENT,
        REMOVE_STATEMENT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum NeoSailRelTypes implements RelationshipType
    {
        REF_TO_NAMESPACE;

    }
}

