/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rdf.sail;

import org.neo4j.rdf.model.BlankNode;
import org.neo4j.rdf.model.CompleteStatement;
import org.neo4j.rdf.model.Context;
import org.neo4j.rdf.model.Uri;
import org.neo4j.rdf.sail.NeoRdfStatementImpl;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;

public class NeoSesameMapper {
    private static final ValueFactory VALUE_FACTORY = new ValueFactoryImpl();

    public static Literal createLiteral(org.neo4j.rdf.model.Literal from) {
        return null == from.getDatatype() ? (null == from.getLanguage() ? VALUE_FACTORY.createLiteral((String)from.getValue()) : VALUE_FACTORY.createLiteral((String)from.getValue(), from.getLanguage())) : VALUE_FACTORY.createLiteral((String)from.getValue(), NeoSesameMapper.createUri(from.getDatatype()));
    }

    public static BNode createBlankNode(BlankNode from) {
        return VALUE_FACTORY.createBNode(from.getInternalIdOrNull());
    }

    public static URI createUri(Uri from) {
        return VALUE_FACTORY.createURI(from.getUriAsString());
    }

    public static Resource createResource(org.neo4j.rdf.model.Resource from) {
        return from instanceof Uri ? NeoSesameMapper.createUri((Uri)from) : NeoSesameMapper.createBlankNode((BlankNode)from);
    }

    public static Value createValue(org.neo4j.rdf.model.Value from) {
        return from instanceof org.neo4j.rdf.model.Literal ? NeoSesameMapper.createLiteral((org.neo4j.rdf.model.Literal)from) : (from instanceof Uri ? NeoSesameMapper.createUri((Uri)from) : NeoSesameMapper.createBlankNode((BlankNode)from));
    }

    public static Resource createContext(Context from) {
        return from == null || from.equals((Object)Context.NULL) ? null : VALUE_FACTORY.createURI(from.getUriAsString());
    }

    public static Statement createStatement(CompleteStatement from, boolean readMetadata) {
        Statement result;
        Context context = from.getContext();
        if (context != null && context.isWildcard()) {
            throw new IllegalArgumentException("Cannot have wildcard context");
        }
        Statement statement = result = null == context ? VALUE_FACTORY.createStatement(NeoSesameMapper.createResource(from.getSubject()), NeoSesameMapper.createUri(from.getPredicate()), NeoSesameMapper.createValue(from.getObject())) : VALUE_FACTORY.createStatement(NeoSesameMapper.createResource(from.getSubject()), NeoSesameMapper.createUri(from.getPredicate()), NeoSesameMapper.createValue(from.getObject()), NeoSesameMapper.createContext(context));
        if (readMetadata) {
            result = new NeoRdfStatementImpl(result, from);
        }
        return result;
    }
}

