/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rdf.sail;

import info.aduna.iteration.CloseableIteration;
import java.util.Iterator;
import javax.transaction.Transaction;
import org.neo4j.rdf.model.CompleteStatement;
import org.neo4j.rdf.sail.NeoSailConnection;
import org.neo4j.rdf.sail.NeoSesameMapper;
import org.openrdf.model.Statement;
import org.openrdf.sail.SailException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NeoStatementIteration
implements CloseableIteration<Statement, SailException> {
    private final Iterator<CompleteStatement> iterator;
    private final NeoSailConnection connection;
    private Statement nextStatement;

    public NeoStatementIteration(Iterator<CompleteStatement> iterator, NeoSailConnection connection) {
        this.iterator = iterator;
        this.connection = connection;
    }

    public void close() throws SailException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNext() throws SailException {
        if (this.nextStatement != null) {
            return true;
        }
        NeoSailConnection neoSailConnection = this.connection;
        synchronized (neoSailConnection) {
            boolean bl;
            Transaction otherTx = this.connection.suspendOtherAndResumeThis();
            try {
                if (this.iterator.hasNext()) {
                    this.nextStatement = this.fetchNextStatement();
                }
                bl = this.nextStatement != null;
                this.connection.suspendThisAndResumeOther(otherTx);
            }
            catch (Throwable throwable) {
                this.connection.suspendThisAndResumeOther(otherTx);
                throw throwable;
            }
            return bl;
        }
    }

    public Statement next() throws SailException {
        if (!this.hasNext()) {
            throw new IllegalStateException();
        }
        Statement result = this.nextStatement;
        this.nextStatement = null;
        return result;
    }

    private Statement fetchNextStatement() throws SailException {
        CompleteStatement statement = this.iterator.next();
        return null == statement ? null : NeoSesameMapper.createStatement(statement, true);
    }

    public void remove() throws SailException {
    }
}

