/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rdf.sail;

import info.aduna.iteration.CloseableIteration;
import java.util.Iterator;
import javax.transaction.Transaction;
import org.neo4j.commons.iterator.IteratorWrapper;
import org.neo4j.rdf.fulltext.QueryResult;
import org.neo4j.rdf.sail.FulltextQueryResult;
import org.neo4j.rdf.sail.NeoSailConnection;
import org.openrdf.sail.SailException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryResultIteration
extends IteratorWrapper<FulltextQueryResult, QueryResult>
implements CloseableIteration<FulltextQueryResult, SailException> {
    private NeoSailConnection connection;

    QueryResultIteration(Iterator<QueryResult> queryResult, NeoSailConnection connection) {
        super(queryResult);
        this.connection = connection;
    }

    public void close() throws SailException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNext() {
        NeoSailConnection neoSailConnection = this.connection;
        synchronized (neoSailConnection) {
            boolean bl;
            Transaction otherTx = this.connection.suspendOtherAndResumeThis();
            try {
                bl = super.hasNext();
                this.connection.suspendThisAndResumeOther(otherTx);
            }
            catch (Throwable throwable) {
                this.connection.suspendThisAndResumeOther(otherTx);
                throw throwable;
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FulltextQueryResult next() {
        NeoSailConnection neoSailConnection = this.connection;
        synchronized (neoSailConnection) {
            FulltextQueryResult fulltextQueryResult;
            Transaction otherTx = this.connection.suspendOtherAndResumeThis();
            try {
                fulltextQueryResult = (FulltextQueryResult)super.next();
                this.connection.suspendThisAndResumeOther(otherTx);
            }
            catch (Throwable throwable) {
                this.connection.suspendThisAndResumeOther(otherTx);
                throw throwable;
            }
            return fulltextQueryResult;
        }
    }

    protected FulltextQueryResult underlyingObjectToObject(QueryResult object) {
        return new FulltextQueryResult(object);
    }
}

