/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rdf.sail;

import org.neo4j.rdf.model.BlankNode;
import org.neo4j.rdf.model.CompleteStatement;
import org.neo4j.rdf.model.Context;
import org.neo4j.rdf.model.Uri;
import org.neo4j.rdf.model.Wildcard;
import org.neo4j.rdf.model.WildcardStatement;
import org.neo4j.rdf.sail.utils.ContextHandling;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public class SesameNeoMapper {
    public static org.neo4j.rdf.model.Literal createLiteral(Literal lit) {
        Uri datatype = null == lit.getDatatype() ? null : SesameNeoMapper.createUri(lit.getDatatype());
        return new org.neo4j.rdf.model.Literal((Object)lit.getLabel(), datatype, lit.getLanguage());
    }

    public static Uri createUri(URI uri) {
        return new Uri(uri.toString());
    }

    public static BlankNode createBlankNode(BNode bnode) {
        return new BlankNode(bnode.getID());
    }

    public static org.neo4j.rdf.model.Resource createResource(Resource res) {
        if (res instanceof URI) {
            return SesameNeoMapper.createUri((URI)res);
        }
        if (res instanceof BNode) {
            return SesameNeoMapper.createBlankNode((BNode)res);
        }
        throw new IllegalArgumentException("bad resource type");
    }

    public static org.neo4j.rdf.model.Value createValue(Value val) {
        return val instanceof Literal ? SesameNeoMapper.createLiteral((Literal)val) : (val instanceof URI ? SesameNeoMapper.createUri((URI)val) : SesameNeoMapper.createBlankNode((BNode)val));
    }

    public static WildcardStatement createWildcardStatement(Resource subject, URI predicate, Value object, Resource ... inContexts) {
        org.neo4j.rdf.model.Value context = ContextHandling.createSingleContext(false, inContexts);
        return new WildcardStatement((org.neo4j.rdf.model.Value)(null == subject ? new Wildcard("?s") : SesameNeoMapper.createResource(subject)), (org.neo4j.rdf.model.Value)(null == predicate ? new Wildcard("?p") : SesameNeoMapper.createUri(predicate)), (org.neo4j.rdf.model.Value)(null == object ? new Wildcard("?o") : SesameNeoMapper.createValue(object)), context);
    }

    public static CompleteStatement createCompleteStatement(Resource subject, URI predicate, Value object, Resource ... inContexts) {
        Context context = (Context)ContextHandling.createSingleContext(true, inContexts);
        if (object instanceof Literal) {
            return new CompleteStatement(SesameNeoMapper.createResource(subject), SesameNeoMapper.createUri(predicate), (org.neo4j.rdf.model.Literal)SesameNeoMapper.createValue(object), context);
        }
        return new CompleteStatement(SesameNeoMapper.createResource(subject), SesameNeoMapper.createUri(predicate), (org.neo4j.rdf.model.Resource)SesameNeoMapper.createValue(object), context);
    }

    public static org.neo4j.rdf.model.Statement createCompleteStatement(Statement st) {
        Context context = ContextHandling.createContext(st.getContext());
        if (st.getObject() instanceof Literal) {
            return new CompleteStatement(SesameNeoMapper.createResource(st.getSubject()), SesameNeoMapper.createUri(st.getPredicate()), (org.neo4j.rdf.model.Literal)SesameNeoMapper.createValue(st.getObject()), context);
        }
        return new CompleteStatement(SesameNeoMapper.createResource(st.getSubject()), SesameNeoMapper.createUri(st.getPredicate()), (org.neo4j.rdf.model.Resource)SesameNeoMapper.createValue(st.getObject()), context);
    }
}

