/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rdf.sail.rmi;

import info.aduna.iteration.CloseableIteration;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.rmi.server.Unreferenced;
import java.util.Collection;
import java.util.LinkedList;
import org.neo4j.rdf.sail.rmi.RmiIterationBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IterationBufferer<E, X extends Exception>
extends UnicastRemoteObject
implements RmiIterationBuffer<E, X>,
Unreferenced {
    private static final int CHUNK_SIZE = 10;
    private final CloseableIteration<E, X> iter;
    private boolean open = true;

    IterationBufferer(CloseableIteration<E, X> iter) throws RemoteException {
        this.iter = iter;
    }

    IterationBufferer(CloseableIteration<E, X> iter, int port) throws RemoteException {
        super(port);
        this.iter = iter;
    }

    IterationBufferer(CloseableIteration<E, X> iter, int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) throws RemoteException {
        super(port, csf, ssf);
        this.iter = iter;
    }

    @Override
    public void close() throws X {
        this.open = false;
        this.iter.close();
    }

    @Override
    public void unreferenced() {
        if (this.open) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public Collection<E> getChunk() throws X, RemoteException {
        if (!this.open) {
            return null;
        }
        LinkedList<Object> data = new LinkedList<Object>();
        for (int count = 10; count > 0 && this.iter.hasNext(); --count) {
            data.add(this.iter.next());
        }
        return data;
    }
}

