/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rdf.sail.rmi;

import info.aduna.iteration.CloseableIteration;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.neo4j.rdf.sail.rmi.RmiIterationBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IterationUnbufferer<E, X extends Exception>
implements CloseableIteration<E, X> {
    private final RmiIterationBuffer<E, X> buffer;
    private Iterator<E> state;

    static <E, X extends Exception> CloseableIteration<E, X> unbuffer(RmiIterationBuffer<E, X> buffer) {
        return new IterationUnbufferer<E, X>(buffer);
    }

    private IterationUnbufferer(RmiIterationBuffer<E, X> buffer) {
        this.buffer = buffer;
    }

    public void close() throws X {
        try {
            this.buffer.close();
        }
        catch (RemoteException ex) {
            throw new RuntimeException("RMI connection failed.", ex);
        }
    }

    public boolean hasNext() throws X {
        Collection<E> data;
        if (this.state != null && this.state.hasNext()) {
            return true;
        }
        try {
            data = this.buffer.getChunk();
        }
        catch (RemoteException ex) {
            return false;
        }
        if (data == null || data.size() == 0) {
            return false;
        }
        this.state = data.iterator();
        return true;
    }

    public E next() throws X {
        if (this.hasNext()) {
            return this.state.next();
        }
        throw new NoSuchElementException();
    }

    public void remove() throws X {
        throw new UnsupportedOperationException();
    }
}

