/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rdf.sail.rmi;

import info.aduna.iteration.CloseableIteration;
import java.rmi.RemoteException;
import java.util.Map;
import org.neo4j.rdf.sail.FulltextQueryResult;
import org.neo4j.rdf.sail.NeoRdfSailConnection;
import org.neo4j.rdf.sail.rmi.IterationUnbufferer;
import org.neo4j.rdf.sail.rmi.RmiSailClient;
import org.neo4j.rdf.sail.rmi.RmiSailConnection;
import org.neo4j.rdf.sail.rmi.RmiSailConnectionListenerCallbackImpl;
import org.neo4j.rdf.sail.utils.SailConnectionTripleSource;
import org.openrdf.model.Literal;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.evaluation.TripleSource;
import org.openrdf.query.algebra.evaluation.impl.EvaluationStrategyImpl;
import org.openrdf.sail.SailConnectionListener;
import org.openrdf.sail.SailException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LocalSailConnection
implements NeoRdfSailConnection {
    private final RmiSailConnection connection;
    private final RmiSailConnectionListenerCallbackImpl callback;

    LocalSailConnection(RmiSailConnection connection, RmiSailConnectionListenerCallbackImpl callback) {
        this.connection = connection;
        this.callback = callback;
    }

    public void addConnectionListener(SailConnectionListener listener) {
        this.callback.listeners.add(listener);
    }

    public void removeConnectionListener(SailConnectionListener listener) {
        this.callback.listeners.remove(listener);
    }

    public void addStatement(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        try {
            this.connection.addStatement(subj, pred, obj, contexts);
        }
        catch (RemoteException ex) {
            throw new SailException("RMI connection failed.", (Throwable)ex);
        }
    }

    @Override
    public Statement addStatement(Map<String, Literal> metadata, Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        try {
            return this.connection.addStatement(metadata, subj, pred, obj, contexts);
        }
        catch (RemoteException ex) {
            throw new SailException("RMI connection failed.", (Throwable)ex);
        }
    }

    public void clear(Resource ... contexts) throws SailException {
        try {
            this.connection.clear(contexts);
        }
        catch (RemoteException ex) {
            throw new SailException("RMI connection failed.", (Throwable)ex);
        }
    }

    public void clearNamespaces() throws SailException {
        try {
            this.connection.clearNamespaces();
        }
        catch (RemoteException ex) {
            throw new SailException("RMI connection failed.", (Throwable)ex);
        }
    }

    public void close() throws SailException {
        try {
            this.connection.close();
        }
        catch (RemoteException ex) {
            throw new SailException("RMI connection failed.", (Throwable)ex);
        }
    }

    public void commit() throws SailException {
        try {
            this.connection.commit();
        }
        catch (RemoteException ex) {
            throw new SailException("RMI connection failed.", (Throwable)ex);
        }
    }

    public CloseableIteration<? extends BindingSet, QueryEvaluationException> evaluate(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings, boolean includeInferred) throws SailException {
        try {
            SailConnectionTripleSource tripleSource = new SailConnectionTripleSource(this, RmiSailClient.valueFactory, includeInferred);
            EvaluationStrategyImpl strategy = new EvaluationStrategyImpl((TripleSource)tripleSource, dataset);
            return strategy.evaluate(tupleExpr, bindings);
        }
        catch (QueryEvaluationException e) {
            throw new SailException((Throwable)e);
        }
    }

    public CloseableIteration<? extends Resource, SailException> getContextIDs() throws SailException {
        try {
            return IterationUnbufferer.unbuffer(this.connection.getContextIDs());
        }
        catch (RemoteException ex) {
            throw new SailException("RMI connection failed.", (Throwable)ex);
        }
    }

    public CloseableIteration<? extends Namespace, SailException> getNamespaces() throws SailException {
        try {
            return IterationUnbufferer.unbuffer(this.connection.getNamespaces());
        }
        catch (RemoteException ex) {
            throw new SailException("RMI connection failed.", (Throwable)ex);
        }
    }

    public CloseableIteration<? extends Statement, SailException> getStatements(Resource subj, URI pred, Value obj, boolean includeInferred, Resource ... contexts) throws SailException {
        try {
            return IterationUnbufferer.unbuffer(this.connection.getStatements(subj, pred, obj, includeInferred, contexts));
        }
        catch (RemoteException ex) {
            throw new SailException("RMI connection failed.", (Throwable)ex);
        }
    }

    public String getNamespace(String prefix) throws SailException {
        try {
            return this.connection.getNamespace(prefix);
        }
        catch (RemoteException ex) {
            throw new SailException("RMI connection failed.", (Throwable)ex);
        }
    }

    public boolean isOpen() throws SailException {
        try {
            return this.connection.isOpen();
        }
        catch (RemoteException ex) {
            throw new SailException("RMI connection failed.", (Throwable)ex);
        }
    }

    public void removeNamespace(String prefix) throws SailException {
        try {
            this.connection.removeNamespace(prefix);
        }
        catch (RemoteException ex) {
            throw new SailException("RMI connection failed.", (Throwable)ex);
        }
    }

    public void removeStatements(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        try {
            this.connection.removeStatements(subj, pred, obj, contexts);
        }
        catch (RemoteException ex) {
            throw new SailException("RMI connection failed.", (Throwable)ex);
        }
    }

    public void rollback() throws SailException {
        try {
            this.connection.rollback();
        }
        catch (RemoteException ex) {
            throw new SailException("RMI connection failed.", (Throwable)ex);
        }
    }

    public void setNamespace(String prefix, String name) throws SailException {
        try {
            this.connection.setNamespace(prefix, name);
        }
        catch (RemoteException ex) {
            throw new SailException("RMI connection failed.", (Throwable)ex);
        }
    }

    public long size(Resource ... contexts) throws SailException {
        try {
            return this.connection.size(contexts);
        }
        catch (RemoteException ex) {
            throw new SailException("RMI connection failed.", (Throwable)ex);
        }
    }

    @Override
    public CloseableIteration<? extends FulltextQueryResult, SailException> evaluate(String query) throws SailException {
        try {
            return IterationUnbufferer.unbuffer(this.connection.evaluate(query));
        }
        catch (RemoteException ex) {
            throw new SailException("RMI connection failed.", (Throwable)ex);
        }
    }

    @Override
    public CloseableIteration<? extends FulltextQueryResult, SailException> evaluateWithSnippets(String query, int snippetCountLimit) throws SailException {
        try {
            return IterationUnbufferer.unbuffer(this.connection.evaluateWithSnippets(query, snippetCountLimit));
        }
        catch (RemoteException ex) {
            throw new SailException("RMI connection failed.", (Throwable)ex);
        }
    }

    @Override
    public void setStatementMetadata(Statement statement, Map<String, Literal> metadata) throws SailException {
        try {
            this.connection.setStatementMetadata(statement, metadata);
        }
        catch (RemoteException e) {
            throw new SailException("RMI connection failed.", (Throwable)e);
        }
    }

    @Override
    public void reindexFulltextIndex() throws SailException {
        try {
            this.connection.reindexFulltextIndex();
        }
        catch (RemoteException e) {
            throw new SailException("RMI connection failed.", (Throwable)e);
        }
    }
}

