/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rdf.sail.rmi;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashSet;
import java.util.Set;
import org.neo4j.rdf.sail.rmi.RmiSailChangedListenerCallback;
import org.neo4j.rdf.sail.rmi.RmiSailClient;
import org.openrdf.sail.Sail;
import org.openrdf.sail.SailChangedEvent;
import org.openrdf.sail.SailChangedListener;

class RmiSailChangedListenerCallbackImpl
extends UnicastRemoteObject
implements RmiSailChangedListenerCallback {
    final Set<SailChangedListener> listeners = new HashSet<SailChangedListener>();
    private final RmiSailClient sail;

    RmiSailChangedListenerCallbackImpl(RmiSailClient sail) throws RemoteException {
        this.sail = sail;
    }

    public boolean sailChanged(boolean statementsAdded, boolean statementsRemoved) {
        Event event = new Event(this.sail, statementsAdded, statementsRemoved);
        for (SailChangedListener listener : this.listeners) {
            listener.sailChanged((SailChangedEvent)event);
        }
        return this.sail.alive;
    }

    private static class Event
    implements SailChangedEvent {
        private final Sail sail;
        private final boolean statementsAdded;
        private final boolean statementsRemoved;

        Event(Sail sail, boolean statementsAdded, boolean statementsRemoved) {
            this.sail = sail;
            this.statementsAdded = statementsAdded;
            this.statementsRemoved = statementsRemoved;
        }

        public Sail getSail() {
            return this.sail;
        }

        public boolean statementsAdded() {
            return this.statementsAdded;
        }

        public boolean statementsRemoved() {
            return this.statementsRemoved;
        }
    }
}

