/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rdf.sail.rmi;

import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.rmi.server.Unreferenced;
import java.util.Map;
import org.neo4j.rdf.sail.FulltextQueryResult;
import org.neo4j.rdf.sail.NeoRdfSailConnection;
import org.neo4j.rdf.sail.rmi.RmiIterationBuffer;
import org.neo4j.rdf.sail.rmi.RmiSailConnection;
import org.neo4j.rdf.sail.rmi.RmiSailServer;
import org.openrdf.model.Literal;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RmiSailConnectionImpl
extends UnicastRemoteObject
implements RmiSailConnection,
Unreferenced {
    private final SailConnection connection;
    private final RmiSailServer.RmiSailConnectionFactory factory;
    private boolean connected = true;

    RmiSailConnectionImpl(SailConnection connection, RmiSailServer.RmiSailConnectionFactory factory) throws RemoteException {
        this.connection = connection;
        this.factory = factory;
    }

    RmiSailConnectionImpl(SailConnection connection, RmiSailServer.RmiSailConnectionFactory factory, int port) throws RemoteException {
        super(port);
        this.connection = connection;
        this.factory = factory;
    }

    RmiSailConnectionImpl(SailConnection connection, RmiSailServer.RmiSailConnectionFactory factory, int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) throws RemoteException {
        super(port, csf, ssf);
        this.connection = connection;
        this.factory = factory;
    }

    void callbackConnectionLost() {
        this.unreferenced();
    }

    @Override
    public void unreferenced() {
        if (this.connected) {
            try {
                if (this.connection.isOpen()) {
                    this.connection.close();
                }
            }
            catch (SailException sailException) {
                // empty catch block
            }
            this.connected = false;
        }
    }

    @Override
    public void addStatement(Resource subj, URI pred, Value obj, Resource[] contexts) throws SailException {
        this.connection.addStatement(subj, pred, obj, contexts);
    }

    @Override
    public Statement addStatement(Map<String, Literal> metadata, Resource subj, URI pred, Value obj, Resource[] contexts) throws SailException {
        return this.getNeoRdfConnection().addStatement(metadata, subj, pred, obj, contexts);
    }

    @Override
    public void clear(Resource[] contexts) throws SailException {
        this.connection.clear(contexts);
    }

    @Override
    public void clearNamespaces() throws SailException {
        this.connection.clearNamespaces();
    }

    @Override
    public void close() throws SailException {
        this.connection.close();
        this.connected = false;
    }

    @Override
    public void commit() throws SailException {
        this.connection.commit();
    }

    @Override
    public String getNamespace(String prefix) throws SailException {
        return this.connection.getNamespace(prefix);
    }

    @Override
    public boolean isOpen() throws SailException {
        return this.connection.isOpen();
    }

    @Override
    public void removeNamespace(String prefix) throws SailException {
        this.connection.removeNamespace(prefix);
    }

    @Override
    public void removeStatements(Resource subj, URI pred, Value obj, Resource[] contexts) throws SailException {
        this.connection.removeStatements(subj, pred, obj, contexts);
    }

    @Override
    public void rollback() throws SailException {
        this.connection.rollback();
    }

    @Override
    public void setNamespace(String prefix, String name) throws SailException {
        this.connection.setNamespace(prefix, name);
    }

    @Override
    public long size(Resource[] contexts) throws SailException {
        return this.connection.size(contexts);
    }

    @Override
    public RmiIterationBuffer<? extends BindingSet, QueryEvaluationException> evaluate(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings, boolean includeInferred) throws SailException, RemoteException {
        return this.factory.buffer(this.connection.evaluate(tupleExpr, dataset, bindings, includeInferred));
    }

    @Override
    public RmiIterationBuffer<? extends Resource, SailException> getContextIDs() throws SailException, RemoteException {
        return this.factory.buffer(this.connection.getContextIDs());
    }

    @Override
    public RmiIterationBuffer<? extends Namespace, SailException> getNamespaces() throws SailException, RemoteException {
        return this.factory.buffer(this.connection.getNamespaces());
    }

    @Override
    public RmiIterationBuffer<? extends Statement, SailException> getStatements(Resource subj, URI pred, Value obj, boolean includeInferred, Resource[] contexts) throws SailException, RemoteException {
        return this.factory.buffer(this.connection.getStatements(subj, pred, obj, includeInferred, contexts));
    }

    private NeoRdfSailConnection getNeoRdfConnection() {
        if (!(this.connection instanceof NeoRdfSailConnection)) {
            throw new RuntimeException("Only available for connections implementing " + NeoRdfSailConnection.class);
        }
        return (NeoRdfSailConnection)this.connection;
    }

    @Override
    public RmiIterationBuffer<? extends FulltextQueryResult, SailException> evaluate(String query) throws SailException, RemoteException {
        NeoRdfSailConnection neoRdfSailCollection = this.getNeoRdfConnection();
        return this.factory.buffer(neoRdfSailCollection.evaluate(query));
    }

    @Override
    public RmiIterationBuffer<? extends FulltextQueryResult, SailException> evaluateWithSnippets(String query, int snippetCountLimit) throws SailException, RemoteException {
        NeoRdfSailConnection neoRdfSailCollection = this.getNeoRdfConnection();
        return this.factory.buffer(neoRdfSailCollection.evaluateWithSnippets(query, snippetCountLimit));
    }

    @Override
    public void setStatementMetadata(Statement statement, Map<String, Literal> metadata) throws SailException, RemoteException {
        NeoRdfSailConnection neoRdfSailCollection = this.getNeoRdfConnection();
        neoRdfSailCollection.setStatementMetadata(statement, metadata);
    }

    @Override
    public void reindexFulltextIndex() throws SailException, RemoteException {
        this.getNeoRdfConnection().reindexFulltextIndex();
    }
}

