/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rdf.sail.utils;

import org.neo4j.rdf.model.Context;
import org.neo4j.rdf.model.Value;
import org.neo4j.rdf.model.Wildcard;
import org.openrdf.model.Resource;

public class ContextHandling {
    public static Context createContext(Resource resource) {
        return null == resource ? Context.NULL : new Context(resource.toString());
    }

    public static Value createSingleContext(boolean mustBeOne, Resource ... contexts) {
        Wildcard context = null;
        if (contexts.length == 0) {
            if (mustBeOne) {
                throw new IllegalArgumentException("Must be exactely one context");
            }
            context = new Wildcard("?g");
        } else if (contexts.length == 1) {
            context = ContextHandling.createContext(contexts[0]);
        } else {
            throw new IllegalArgumentException("Can only have zero or one context");
        }
        return context;
    }

    public static Context[] createContexts(Resource ... resources) {
        if (resources == null) {
            return new Context[]{Context.NULL};
        }
        Context[] neoContexts = new Context[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            neoContexts[i] = ContextHandling.createContext(resources[i]);
        }
        return neoContexts;
    }
}

