/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rdf.sail.utils;

import info.aduna.iteration.CloseableIteration;
import org.neo4j.rdf.sail.utils.EmptyCloseableIteration;
import org.neo4j.rdf.sail.utils.QueryEvaluationIteration;
import org.neo4j.rdf.util.TemporaryLogger;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.evaluation.TripleSource;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SailConnectionTripleSource
implements TripleSource {
    private SailConnection baseConnection;
    private ValueFactory valueFactory;
    private boolean includeInferred;

    public SailConnectionTripleSource(SailConnection conn, ValueFactory valueFactory, boolean includeInferred) {
        this.baseConnection = conn;
        this.valueFactory = valueFactory;
        this.includeInferred = includeInferred;
    }

    public CloseableIteration<? extends Statement, QueryEvaluationException> getStatements(Resource subj, URI pred, Value obj, Resource ... contexts) {
        TemporaryLogger.Timer timer = new TemporaryLogger.Timer();
        try {
            return new QueryEvaluationIteration((CloseableIteration<? extends Statement, SailException>)this.baseConnection.getStatements(subj, pred, obj, this.includeInferred, contexts));
        }
        catch (SailException e) {
            return new EmptyCloseableIteration();
        }
    }

    private String contextsString(Resource ... contexts) {
        if (contexts == null) {
            return "null";
        }
        StringBuffer buffer = new StringBuffer("[");
        int counter = 0;
        for (Resource context : contexts) {
            if (counter++ > 0) {
                buffer.append(",");
            }
            buffer.append(null == context ? "null" : context.toString());
        }
        buffer.append("]");
        return buffer.toString();
    }

    public ValueFactory getValueFactory() {
        return this.valueFactory;
    }
}

