/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util;

import org.neo4j.api.core.Direction;
import org.neo4j.api.core.EmbeddedNeo;
import org.neo4j.api.core.NeoService;
import org.neo4j.api.core.Node;
import org.neo4j.api.core.Relationship;
import org.neo4j.api.core.RelationshipType;
import org.neo4j.api.core.Transaction;
import org.neo4j.impl.transaction.IllegalResourceException;
import org.neo4j.impl.transaction.LockManager;
import org.neo4j.util.Link;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLink<T>
implements Link<T> {
    private final NeoService neo;
    private final Node node;
    private final RelationshipType type;
    private final Direction direction;

    public AbstractLink(NeoService neo, Node node, RelationshipType type, Direction direction) {
        this.neo = neo;
        this.node = node;
        this.type = type;
        this.direction = direction;
    }

    public AbstractLink(NeoService neo, Node node, RelationshipType type) {
        this(neo, node, type, Direction.OUTGOING);
    }

    protected NeoService neo() {
        return this.neo;
    }

    protected Node node() {
        return this.node;
    }

    protected Direction direction() {
        return this.direction;
    }

    protected RelationshipType type() {
        return this.type;
    }

    protected abstract T newObject(Node var1);

    private T newObject(Relationship relationship) {
        return this.newObject(relationship.getOtherNode(this.node));
    }

    protected abstract Node getNodeFromItem(T var1);

    protected Relationship getLinkRelationshipOrNull() {
        return this.node.getSingleRelationship(this.type(), this.direction());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        Transaction tx = this.neo.beginTx();
        try {
            Relationship relationship = this.getLinkRelationshipOrNull();
            T result = relationship == null ? null : (T)this.newObject(relationship);
            tx.success();
            T t = result;
            return t;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean has() {
        Transaction tx = this.neo.beginTx();
        try {
            boolean result = this.getLinkRelationshipOrNull() != null;
            tx.success();
            boolean bl = result;
            return bl;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T remove() {
        Transaction tx = this.neo.beginTx();
        try {
            Relationship relationship = this.getLinkRelationshipOrNull();
            T result = null;
            if (relationship != null) {
                result = this.newObject(relationship);
                this.entityRemoved(result, relationship);
                relationship.delete();
            }
            tx.success();
            T t = result;
            return t;
        }
        finally {
            tx.finish();
        }
    }

    @Override
    public T set(T object) {
        Transaction tx = this.neo.beginTx();
        LockManager lockManager = ((EmbeddedNeo)this.neo).getConfig().getLockManager();
        try {
            lockManager.getWriteLock((Object)this.node());
            Relationship existingRelationship = this.getLinkRelationshipOrNull();
            T existingObject = null;
            if (existingRelationship != null) {
                existingObject = this.newObject(existingRelationship);
                this.entityRemoved(existingObject, existingRelationship);
                existingRelationship.delete();
            }
            Node entityNode = this.getNodeFromItem(object);
            Node startNode = this.direction() == Direction.OUTGOING ? this.node() : entityNode;
            Node endNode = this.direction() == Direction.OUTGOING ? entityNode : this.node();
            Relationship createdRelationship = startNode.createRelationshipTo(endNode, this.type());
            this.entitySet(object, createdRelationship);
            tx.success();
            T t = existingObject;
            return t;
        }
        catch (IllegalResourceException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                lockManager.releaseWriteLock((Object)this.node());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            tx.finish();
        }
    }

    protected void entitySet(T entity, Relationship createdRelationship) {
    }

    protected void entityRemoved(T entity, Relationship removedRelationship) {
    }
}

