/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util;

import java.util.Collection;
import org.neo4j.api.core.NeoService;
import org.neo4j.api.core.Transaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNeoSet<T>
implements Collection<T> {
    private NeoService neo;

    public AbstractNeoSet(NeoService neo) {
        this.neo = neo;
    }

    protected NeoService neo() {
        return this.neo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends T> items) {
        Transaction tx = this.neo().beginTx();
        try {
            boolean changed = false;
            for (T item : items) {
                if (!this.add(item)) continue;
                changed = true;
            }
            tx.success();
            boolean bl = changed;
            return bl;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(Collection<?> items) {
        Transaction tx = this.neo().beginTx();
        try {
            boolean ok = true;
            for (Object item : items) {
                if (this.contains(item)) continue;
                ok = false;
                break;
            }
            tx.success();
            boolean bl = ok;
            return bl;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> items) {
        Transaction tx = this.neo().beginTx();
        try {
            boolean changed = false;
            for (Object item : items) {
                if (!this.remove(item)) continue;
                changed = true;
            }
            tx.success();
            boolean bl = changed;
            return bl;
        }
        finally {
            tx.finish();
        }
    }
}

