/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util;

import java.util.ArrayList;
import java.util.HashSet;
import org.neo4j.util.CrudEventData;
import org.neo4j.util.EventBufferFilter;
import org.neo4j.util.EventContext;

public class CrudEventBufferFilter
implements EventBufferFilter {
    public EventContext[] filter(EventContext[] events) {
        HashSet<Long> deleted = new HashSet<Long>();
        for (EventContext context : events) {
            CrudEventData data = (CrudEventData)context.getData().getData();
            if (data.getAlterationMode() != CrudEventData.AlterationMode.DELETED) continue;
            deleted.add(data.getNodeId());
        }
        HashSet<Long> taken = new HashSet<Long>();
        ArrayList<EventContext> list = new ArrayList<EventContext>();
        for (EventContext context : events) {
            CrudEventData data = (CrudEventData)context.getData().getData();
            long nodeId = data.getNodeId();
            if (data.getAlterationMode() == CrudEventData.AlterationMode.DELETED) {
                list.add(context);
                continue;
            }
            if (taken.contains(nodeId) || deleted.contains(nodeId)) continue;
            list.add(context);
            taken.add(nodeId);
        }
        return list.toArray(new EventContext[list.size()]);
    }
}

