/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util;

import org.neo4j.impl.transaction.DeadlockDetectedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DeadlockCapsule<T> {
    private int maxNumberOfTries;
    private long millisToSleepBetweenTries;

    public DeadlockCapsule(String name) {
        this(name, 5);
    }

    public DeadlockCapsule(String name, int maxNumberOfTries) {
        this(name, maxNumberOfTries, 20L);
    }

    public DeadlockCapsule(String name, int maxNumberOfTries, long millisToSleepBetweenTries) {
        this.maxNumberOfTries = maxNumberOfTries;
        this.millisToSleepBetweenTries = millisToSleepBetweenTries;
    }

    public abstract T tryOnce();

    public final T run() {
        int tries = 0;
        while (true) {
            ++tries;
            try {
                return this.tryOnce();
            }
            catch (DeadlockDetectedException e) {
                try {
                    Thread.sleep(this.millisToSleepBetweenTries);
                    continue;
                }
                catch (InterruptedException ie) {
                    Thread.interrupted();
                    ie.printStackTrace();
                }
                if (tries < this.maxNumberOfTries) continue;
                return null;
            }
            break;
        }
    }
}

