/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util;

import java.util.Collection;
import java.util.HashSet;
import org.neo4j.api.core.Node;
import org.neo4j.api.core.Relationship;
import org.neo4j.util.NeoDeletor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntireGraphDeletor
implements NeoDeletor {
    @Override
    public void delete(Node startNode) {
        this.removeNodeAndThoseConnectedWith(new HashSet<Node>(), new HashSet<Relationship>(), startNode);
    }

    private void removeNodeAndThoseConnectedWith(Collection<Node> deletedNodes, Collection<Relationship> deletedRels, Node node) {
        for (Relationship rel : node.getRelationships()) {
            Node sub = rel.getOtherNode(node);
            if (deletedRels.add(rel)) {
                this.aboutToDeleteRelationship(rel);
                rel.delete();
            }
            this.removeNodeAndThoseConnectedWith(deletedNodes, deletedRels, sub);
        }
        if (deletedNodes.add(node)) {
            this.aboutToDeleteNode(node);
            node.delete();
        }
    }

    protected void aboutToDeleteRelationship(Relationship relationship) {
    }

    protected void aboutToDeleteNode(Node node) {
    }
}

