/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import org.neo4j.api.core.Direction;
import org.neo4j.api.core.NeoService;
import org.neo4j.api.core.Node;
import org.neo4j.api.core.Relationship;
import org.neo4j.api.core.RelationshipType;
import org.neo4j.api.core.Transaction;
import org.neo4j.commons.iterator.IterableWrapper;
import org.neo4j.util.AbstractNeoSet;
import org.neo4j.util.NodeWrapper;
import org.neo4j.util.NodeWrapperImpl;
import org.neo4j.util.TxIterator;
import org.neo4j.util.btree.BTree;
import org.neo4j.util.sortedtree.SortedTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexedNeoCollection<T extends NodeWrapper>
extends AbstractNeoSet<T> {
    private Node rootNode;
    private Class<T> instanceClass;
    private Comparator<T> comparator;
    private SortedTree index;

    public IndexedNeoCollection(NeoService neo, Node rootNode, Comparator<T> comparator, Class<T> instanceClass) {
        super(neo);
        this.rootNode = rootNode;
        this.instanceClass = instanceClass;
        this.comparator = comparator;
        this.instantiateIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node ensureTheresARoot() {
        Transaction tx = this.neo().beginTx();
        try {
            Node result = null;
            Relationship relationship = this.rootNode.getSingleRelationship((RelationshipType)BTree.RelTypes.TREE_ROOT, Direction.OUTGOING);
            if (relationship != null) {
                result = relationship.getOtherNode(this.rootNode);
            } else {
                result = this.neo().createNode();
                this.rootNode.createRelationshipTo(result, (RelationshipType)BTree.RelTypes.TREE_ROOT);
            }
            tx.success();
            Node node = result;
            return node;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void instantiateIndex() {
        Transaction tx = this.neo().beginTx();
        try {
            Node treeRootNode = this.ensureTheresARoot();
            this.index = new SortedTree(this.neo(), treeRootNode, new ComparatorWrapper(this.comparator));
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    protected Node rootNode() {
        return this.rootNode;
    }

    protected SortedTree index() {
        return this.index;
    }

    protected T instantiateItem(Node itemNode) {
        return NodeWrapperImpl.newInstance(this.instanceClass, this.neo(), itemNode);
    }

    @Override
    public boolean add(T item) {
        return this.index().addNode(item.getUnderlyingNode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Transaction tx = this.neo().beginTx();
        try {
            this.index().delete();
            this.instantiateIndex();
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    @Override
    public boolean contains(Object item) {
        NodeWrapper nodeItem = (NodeWrapper)item;
        return this.index().containsNode(nodeItem.getUnderlyingNode());
    }

    @Override
    public boolean isEmpty() {
        return this.index().getSortedNodes().iterator().hasNext();
    }

    @Override
    public Iterator<T> iterator() {
        Iterator iterator = new IterableWrapper<T, Node>(this.index().getSortedNodes()){

            protected T underlyingObjectToObject(Node node) {
                return IndexedNeoCollection.this.instantiateItem(node);
            }
        }.iterator();
        return new TxIterator(this.neo(), iterator);
    }

    @Override
    public boolean remove(Object item) {
        NodeWrapper nodeItem = (NodeWrapper)item;
        return this.index().removeNode(nodeItem.getUnderlyingNode());
    }

    @Override
    public boolean retainAll(Collection<?> items) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public int size() {
        return this.toArray().length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> Collection<R> toCollection() {
        Transaction tx = this.neo().beginTx();
        try {
            ArrayList<T> result = new ArrayList<T>();
            for (Node node : this.index().getSortedNodes()) {
                result.add(this.instantiateItem(node));
            }
            tx.success();
            ArrayList<T> arrayList = result;
            return arrayList;
        }
        finally {
            tx.finish();
        }
    }

    @Override
    public Object[] toArray() {
        return this.toCollection().toArray();
    }

    @Override
    public <R> R[] toArray(R[] array) {
        return this.toCollection().toArray(array);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() {
        Transaction tx = this.neo().beginTx();
        try {
            this.index().delete();
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ComparatorWrapper
    implements Comparator<Node> {
        private Comparator<T> source;

        ComparatorWrapper(Comparator<T> source) {
            this.source = source;
        }

        @Override
        public int compare(Node o1, Node o2) {
            return this.source.compare(NodeWrapperImpl.newInstance(IndexedNeoCollection.this.instanceClass, IndexedNeoCollection.this.neo(), o1), NodeWrapperImpl.newInstance(IndexedNeoCollection.this.instanceClass, IndexedNeoCollection.this.neo(), o2));
        }
    }
}

