/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util;

import org.neo4j.api.core.NeoService;
import org.neo4j.api.core.Node;
import org.neo4j.api.core.Transaction;
import org.neo4j.util.Migrator;

public abstract class Migration {
    private NeoService neo;
    private Node configNode;
    private boolean firstVersionIsAlwaysZero;
    private boolean pretending;

    public Migration(NeoService neo, Node configNode) {
        this.neo = neo;
        this.configNode = configNode;
    }

    private Node getConfigNode() {
        return this.configNode;
    }

    protected String getCurrentVersionPropertyKey() {
        return "current_version";
    }

    protected abstract Migrator findMigrator(int var1);

    protected abstract int getCodeVersion();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDataVersion() {
        Transaction tx = this.neo.beginTx();
        try {
            int result = 0;
            String key = this.getCurrentVersionPropertyKey();
            if (this.getConfigNode().hasProperty(key)) {
                result = (Integer)this.getConfigNode().getProperty(key);
            } else {
                result = this.firstVersionIsAlwaysZero ? 0 : this.getCodeVersion();
                this.getConfigNode().setProperty(key, (Object)result);
            }
            if (this.firstVersionIsAlwaysZero) {
                result = (Integer)this.getConfigNode().getProperty(key, (Object)0);
            } else if (this.getConfigNode().hasProperty(key)) {
                result = (Integer)this.getConfigNode().getProperty(key);
            } else {
                result = this.getCodeVersion();
                this.getConfigNode().setProperty(key, (Object)result);
            }
            tx.success();
            int n = result;
            return n;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataVersion(int version) {
        Transaction tx = this.neo.beginTx();
        try {
            this.getConfigNode().setProperty(this.getCurrentVersionPropertyKey(), (Object)version);
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    public void setPretend(boolean pretend) {
        this.pretending = pretend;
    }

    public void setFirstVersionIsAlwaysZero(boolean firstIsZero) {
        this.firstVersionIsAlwaysZero = firstIsZero;
    }

    public void syncVersion() {
        int dataVersion;
        int codeVersion = this.getCodeVersion();
        if (codeVersion == (dataVersion = this.getDataVersion())) {
            return;
        }
        if (codeVersion < dataVersion) {
            throw new RuntimeException("Backwards migration not supported");
        }
        int versionToMigrate = 0;
        try {
            for (versionToMigrate = dataVersion + 1; versionToMigrate <= codeVersion; ++versionToMigrate) {
                this.migrateOne(versionToMigrate);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Migration[v" + dataVersion + "-v" + codeVersion + "] FAILED, specifically v" + versionToMigrate, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateOne(int version) {
        Transaction tx = this.neo.beginTx();
        try {
            System.out.println("Migrating ==> version " + version);
            this.findMigrator(version).performMigration(this.neo);
            this.setDataVersion(version);
            if (!this.pretending) {
                tx.success();
            }
        }
        finally {
            tx.finish();
        }
    }
}

