/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util;

import java.io.PrintStream;
import java.util.TreeSet;
import org.neo4j.api.core.NeoService;
import org.neo4j.api.core.Node;
import org.neo4j.api.core.NotFoundException;
import org.neo4j.api.core.Relationship;
import org.neo4j.api.core.Transaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NeoDebugUtil {
    private NeoService neo;

    public NeoDebugUtil(NeoService neo) {
        this.neo = neo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printNodeInfo(int nodeId, PrintStream writer) {
        Transaction tx = this.neo.beginTx();
        try {
            writer.println("--- Printing Node info for " + nodeId + " ---");
            Node node = this.neo.getNodeById((long)nodeId);
            writer.println("Relationships: ");
            for (Relationship rel : node.getRelationships()) {
                writer.print(rel.getType() + "(" + rel.getId() + ")");
                if (rel.getStartNode().equals(node)) {
                    writer.print(" --> ");
                } else {
                    writer.print(" <-- ");
                }
                writer.println(rel.getOtherNode(node));
            }
            String[] sortedKeys = NeoDebugUtil.sortIndexes(node.getPropertyKeys());
            writer.println("Properties:");
            for (int i = 0; i < sortedKeys.length; ++i) {
                writer.println(sortedKeys[i] + "=" + node.getProperty(sortedKeys[i]));
            }
            tx.success();
        }
        catch (NotFoundException e) {
            writer.println("Node id " + nodeId + " not found");
        }
        finally {
            tx.finish();
        }
    }

    public void printRelationshipInfo(Relationship rel, PrintStream writer) {
        Transaction tx = this.neo.beginTx();
        try {
            writer.println("--- Printing Relationship info for " + rel.getId() + " ---");
            writer.println("Start node: " + rel.getStartNode());
            writer.println("End node: " + rel.getEndNode());
            String[] sortedKeys = NeoDebugUtil.sortIndexes(rel.getPropertyKeys());
            writer.println("Properties:");
            for (int i = 0; i < sortedKeys.length; ++i) {
                writer.println(sortedKeys[i] + "=" + rel.getProperty(sortedKeys[i]));
            }
            tx.success();
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        finally {
            tx.finish();
        }
    }

    private static String[] sortIndexes(Iterable<String> keys) {
        TreeSet<String> set = new TreeSet<String>();
        for (String key : keys) {
            set.add(key);
        }
        return set.toArray(new String[set.size()]);
    }
}

