/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.neo4j.api.core.NeoService;
import org.neo4j.api.core.PropertyContainer;
import org.neo4j.api.core.Transaction;
import org.neo4j.commons.iterator.CollectionWrapper;
import org.neo4j.util.AbstractNeoSet;
import org.neo4j.util.NeoUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NeoPropertyArraySet<T>
extends AbstractNeoSet<T>
implements List<T> {
    private PropertyContainer container;
    private String key;
    private NeoUtil neoUtil;

    public NeoPropertyArraySet(NeoService neo, PropertyContainer container, String key) {
        super(neo);
        this.neoUtil = new NeoUtil(neo);
        this.container = container;
        this.key = key;
    }

    protected NeoUtil neoUtil() {
        return this.neoUtil;
    }

    protected PropertyContainer container() {
        return this.container;
    }

    protected String key() {
        return this.key;
    }

    @Override
    public boolean add(T o) {
        return this.neoUtil().addValueToArray(this.container(), this.key(), o);
    }

    @Override
    public void clear() {
        this.neoUtil().removeProperty(this.container(), this.key());
    }

    private List<Object> values() {
        return this.neoUtil().getPropertyValues(this.container(), this.key());
    }

    private void setValues(Collection<?> collection) {
        this.neoUtil().setProperty(this.container(), this.key(), this.neoUtil().asNeoProperty(collection));
    }

    @Override
    public boolean contains(Object o) {
        return this.values().contains(o);
    }

    @Override
    public boolean isEmpty() {
        return this.values().isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return new CollectionWrapper<T, Object>(this.neoUtil().getPropertyValues(this.container(), this.key())){

            protected Object objectToUnderlyingObject(T object) {
                return object;
            }

            protected T underlyingObjectToObject(Object object) {
                return object;
            }
        }.iterator();
    }

    @Override
    public boolean remove(Object o) {
        return this.neoUtil().removeValueFromArray(this.container(), this.key(), o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> c) {
        Transaction tx = this.neoUtil().neo().beginTx();
        try {
            List<Object> values = this.values();
            boolean altered = values.retainAll(c);
            if (altered) {
                if (values.isEmpty()) {
                    this.container().removeProperty(this.key());
                } else {
                    this.container().setProperty(this.key(), this.neoUtil().asNeoProperty(values));
                }
            }
            tx.success();
            boolean bl = altered;
            return bl;
        }
        finally {
            tx.finish();
        }
    }

    @Override
    public int size() {
        return this.values().size();
    }

    @Override
    public Object[] toArray() {
        return this.values().toArray();
    }

    @Override
    public <R> R[] toArray(R[] a) {
        return this.values().toArray(a);
    }

    @Override
    public T set(int index, T value) {
        List<Object> values = this.values();
        Object oldValue = values.set(index, value);
        this.setValues(values);
        return (T)oldValue;
    }

    @Override
    public T remove(int index) {
        List<Object> values = this.values();
        Object oldValue = values.remove(index);
        this.setValues(values);
        return (T)oldValue;
    }

    @Override
    public int lastIndexOf(Object value) {
        return this.values().lastIndexOf(value);
    }

    @Override
    public int indexOf(Object value) {
        return this.values().indexOf(value);
    }

    @Override
    public boolean addAll(int index, Collection collection) {
        List<Object> values = this.values();
        boolean result = values.addAll(collection);
        if (result) {
            this.setValues(values);
        }
        return result;
    }

    @Override
    public void add(int index, T item) {
        List<Object> values = this.values();
        values.add(index, item);
        this.setValues(values);
    }

    @Override
    public ListIterator<T> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<T> subList(int start, int end) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T get(int index) {
        return (T)this.values().get(index);
    }
}

