/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Pattern;
import org.neo4j.api.core.NeoService;
import org.neo4j.api.core.Node;
import org.neo4j.api.core.Transaction;
import org.neo4j.util.AbstractNeoSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NeoPropertySet<T>
extends AbstractNeoSet<T>
implements Set<T> {
    public static final String DEFAULT_DELIMITER = "|";
    private Node node;
    private String key;
    private String delimiter;

    public NeoPropertySet(NeoService neo, Node node, String propertyKey) {
        this(neo, node, propertyKey, DEFAULT_DELIMITER);
    }

    public NeoPropertySet(NeoService neo, Node node, String propertyKey, String delimiter) {
        super(neo);
        this.node = node;
        this.key = propertyKey;
        this.delimiter = delimiter;
    }

    protected abstract String itemToString(Object var1);

    protected abstract T stringToItem(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> tokenize() {
        Transaction tx = this.neo().beginTx();
        try {
            String value;
            HashSet<String> set = new HashSet<String>();
            if (this.node.hasProperty(this.key) && (value = (String)this.node.getProperty(this.key)).length() > 0) {
                for (String token : value.split(Pattern.quote(this.delimiter))) {
                    set.add(token);
                }
            }
            tx.success();
            HashSet<String> hashSet = set;
            return hashSet;
        }
        finally {
            tx.finish();
        }
    }

    private String glue(Set<String> set) {
        StringBuffer buffer = new StringBuffer();
        for (String token : set) {
            if (buffer.length() > 0) {
                buffer.append(this.delimiter);
            }
            buffer.append(token);
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store(String value, boolean changed) {
        if (!changed) {
            return;
        }
        Transaction tx = this.neo().beginTx();
        try {
            this.node.setProperty(this.key, (Object)value);
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(T item) {
        Transaction tx = this.neo().beginTx();
        try {
            Set<String> set = this.tokenize();
            boolean changed = set.add(this.itemToString(item));
            this.store(this.glue(set), changed);
            tx.success();
            boolean bl = changed;
            return bl;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Transaction tx = this.neo().beginTx();
        try {
            if (this.node.hasProperty(this.key)) {
                this.node.removeProperty(this.key);
            }
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    @Override
    public boolean contains(Object item) {
        return this.tokenize().contains(this.itemToString(item));
    }

    @Override
    public boolean isEmpty() {
        return this.tokenize().size() == 0;
    }

    @Override
    public Iterator<T> iterator() {
        return new ItemIterator(this.tokenize().iterator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object item) {
        Transaction tx = this.neo().beginTx();
        try {
            Set<String> set = this.tokenize();
            boolean changed = set.remove(this.itemToString(item));
            this.store(this.glue(set), changed);
            tx.success();
            boolean bl = changed;
            return bl;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> realItems) {
        Transaction tx = this.neo().beginTx();
        try {
            ArrayList<String> items = new ArrayList<String>();
            for (Object item : realItems) {
                items.add(this.itemToString(item));
            }
            Set<String> set = this.tokenize();
            boolean changed = set.retainAll(items);
            this.store(this.glue(set), changed);
            tx.success();
            boolean bl = changed;
            return bl;
        }
        finally {
            tx.finish();
        }
    }

    @Override
    public int size() {
        return this.tokenize().size();
    }

    @Override
    public Object[] toArray() {
        return this.tokenize().toArray();
    }

    @Override
    public <R> R[] toArray(R[] array) {
        Object[] source = this.tokenize().toArray();
        for (int i = 0; i < source.length; ++i) {
            array[i] = this.stringToItem((String)source[i]);
        }
        return array;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ItemIterator
    implements Iterator<T> {
        private Iterator<String> iterator;

        ItemIterator(Iterator<String> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            return NeoPropertySet.this.stringToItem(this.iterator.next());
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

