/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util;

import java.util.ArrayList;
import org.neo4j.api.core.Direction;
import org.neo4j.api.core.NeoService;
import org.neo4j.api.core.Node;
import org.neo4j.api.core.Relationship;
import org.neo4j.api.core.RelationshipType;
import org.neo4j.api.core.Transaction;
import org.neo4j.util.NeoUtil;

public class NeoQueue {
    private NeoService neo;
    private Node rootNode;
    private RelationshipType relType;
    private NeoUtil neoUtil;

    public NeoQueue(NeoService neo, Node rootNode, RelationshipType relType) {
        this.neo = neo;
        this.rootNode = rootNode;
        this.relType = relType;
        this.neoUtil = new NeoUtil(neo);
    }

    private Relationship getFirstRelationship() {
        return this.rootNode.getSingleRelationship(this.relType, Direction.OUTGOING);
    }

    private Relationship getLastRelationship() {
        return this.rootNode.getSingleRelationship(this.relType, Direction.INCOMING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node add() {
        Transaction tx = this.neo.beginTx();
        this.neoUtil.getLockManager().getWriteLock((Object)this.rootNode);
        try {
            Node node = this.neo.createNode();
            Relationship rel = this.getLastRelationship();
            if (rel == null) {
                this.rootNode.createRelationshipTo(node, this.relType);
            } else {
                Node lastNode = rel.getStartNode();
                rel.delete();
                lastNode.createRelationshipTo(node, this.relType);
            }
            node.createRelationshipTo(this.rootNode, this.relType);
            tx.success();
            Node node2 = node;
            return node2;
        }
        finally {
            this.neoUtil.getLockManager().releaseWriteLock((Object)this.rootNode);
            tx.finish();
        }
    }

    public boolean remove() {
        return this.remove(1) == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int remove(int max) {
        Transaction tx = this.neo.beginTx();
        this.neoUtil.getLockManager().getWriteLock((Object)this.rootNode);
        try {
            Relationship rel = this.getFirstRelationship();
            int removed = 0;
            if (rel != null) {
                Object node = rel.getEndNode();
                Object nextNode = null;
                for (int i = 0; i < max; ++i) {
                    Relationship relToNext = node.getSingleRelationship(this.relType, Direction.OUTGOING);
                    nextNode = relToNext.getEndNode();
                    for (Relationship relToDel : node.getRelationships(new RelationshipType[]{this.relType})) {
                        relToDel.delete();
                    }
                    node.delete();
                    ++removed;
                    if (nextNode.equals(this.rootNode)) break;
                    node = nextNode;
                }
                if (nextNode != null && !nextNode.equals(this.rootNode)) {
                    this.rootNode.createRelationshipTo((Node)nextNode, this.relType);
                }
            }
            tx.success();
            int n = removed;
            return n;
        }
        finally {
            this.neoUtil.getLockManager().releaseWriteLock((Object)this.rootNode);
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node peek() {
        Transaction tx = this.neo.beginTx();
        try {
            Relationship rel = this.getFirstRelationship();
            Node result = null;
            if (rel != null) {
                result = rel.getEndNode();
            }
            tx.success();
            Node node = result;
            return node;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node[] peek(int max) {
        Transaction tx = this.neo.beginTx();
        try {
            Node otherNode;
            Relationship rel;
            ArrayList<Node> result = new ArrayList<Node>(max);
            Node node = this.rootNode;
            for (int i = 0; i < max && (rel = node.getSingleRelationship(this.relType, Direction.OUTGOING)) != null && !(otherNode = rel.getEndNode()).equals(this.rootNode); ++i) {
                result.add(otherNode);
                node = otherNode;
            }
            tx.success();
            Node[] nodeArray = result.toArray(new Node[0]);
            return nodeArray;
        }
        finally {
            tx.finish();
        }
    }
}

