/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.api.core.NeoService;
import org.neo4j.api.core.Node;
import org.neo4j.api.core.Transaction;
import org.neo4j.util.DeadlockCapsule;
import org.neo4j.util.NeoQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NeoQueueWorker
extends Thread {
    private final NeoService neo;
    private final NeoQueue queue;
    private boolean halted;
    private boolean requestedToPause;
    private boolean paused;
    private int batchSize;

    public NeoQueueWorker(NeoService neo, NeoQueue queue, int batchSize, String name) {
        super(name);
        this.neo = neo;
        this.queue = queue;
        this.batchSize = batchSize;
    }

    public NeoQueueWorker(NeoService neo, NeoQueue queue, int batchSize) {
        this(neo, queue, batchSize, "NeoQueueWorker");
    }

    public NeoQueue getQueue() {
        return this.queue;
    }

    public void setPaused(boolean paused) {
        if (this.paused == paused) {
            return;
        }
        if (paused && this.requestedToPause) {
            this.waitUntilReallyPaused();
            return;
        }
        this.requestedToPause = paused;
        if (paused) {
            this.waitUntilReallyPaused();
        } else {
            this.paused = false;
        }
    }

    private void waitUntilReallyPaused() {
        while (!this.paused) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public boolean isPaused() {
        return this.paused;
    }

    private void sleepQuiet(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        while (!this.halted) {
            if (this.requestedToPause || this.paused) {
                this.paused = true;
                this.requestedToPause = false;
                this.sleepQuiet(1000L);
                continue;
            }
            if (this.executeOneBatch()) continue;
            this.sleepQuiet(100L);
        }
    }

    public void add(Map<String, Object> values) {
        Node entry = this.queue.add();
        for (Map.Entry<String, Object> value : values.entrySet()) {
            entry.setProperty(value.getKey(), value.getValue());
        }
    }

    protected void beforeBatch() {
    }

    protected void afterBatch() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeOneBatch() {
        int entrySize = 0;
        ArrayList<Map<String, Object>> entries = null;
        Transaction tx = this.neo.beginTx();
        try {
            Node[] nodes = this.queue.peek(this.batchSize);
            if (nodes.length == 0) {
                boolean bl = false;
                return bl;
            }
            entrySize = nodes.length;
            entries = new ArrayList<Map<String, Object>>(entrySize);
            for (Node node : nodes) {
                entries.add(this.readNode(node));
            }
            this.beforeBatch();
            try {
                for (Map map : entries) {
                    this.doOne(map);
                }
                final int size = entrySize;
                new DeadlockCapsule<Object>("remover"){

                    @Override
                    public Object tryOnce() {
                        NeoQueueWorker.this.queue.remove(size);
                        return null;
                    }
                }.run();
            }
            catch (Exception e) {
            }
            finally {
                this.afterBatch();
            }
            tx.success();
        }
        finally {
            tx.finish();
        }
        return true;
    }

    private Map<String, Object> readNode(Node node) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String key : node.getPropertyKeys()) {
            result.put(key, node.getProperty(key));
        }
        return result;
    }

    private void doOne(Map<String, Object> entry) throws Exception {
        Exception exception = null;
        for (int i = 0; !this.halted && i < 10; ++i) {
            try {
                this.doHandleEntry(entry);
                return;
            }
            catch (Exception e) {
                exception = e;
                this.sleepQuiet(500L);
                continue;
            }
        }
        this.handleEntryError(entry, exception);
    }

    protected void handleEntryError(Map<String, Object> entry, Exception exception) throws Exception {
        this.add(entry);
    }

    private void doHandleEntry(Map<String, Object> entry) {
        this.handleEntry(entry);
    }

    protected abstract void handleEntry(Map<String, Object> var1);

    public void startUp() {
        this.start();
    }

    public void shutDown() {
        this.halted = true;
        while (this.isAlive()) {
            this.sleepQuiet(200L);
        }
    }
}

