/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.neo4j.api.core.Direction;
import org.neo4j.api.core.NeoService;
import org.neo4j.api.core.Node;
import org.neo4j.api.core.Relationship;
import org.neo4j.api.core.RelationshipType;
import org.neo4j.api.core.Transaction;
import org.neo4j.commons.iterator.FilteringIterator;
import org.neo4j.commons.iterator.IteratorWrapper;
import org.neo4j.util.AbstractNeoSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NeoRelationshipSet<T>
extends AbstractNeoSet<T>
implements Set<T> {
    private Node node;
    private RelationshipType type;
    private Direction direction;

    public NeoRelationshipSet(NeoService neo, Node node, RelationshipType type) {
        this(neo, node, type, Direction.OUTGOING);
    }

    public NeoRelationshipSet(NeoService neo, Node node, RelationshipType type, Direction direction) {
        super(neo);
        if (direction == null || direction == Direction.BOTH) {
            throw new IllegalArgumentException("Only OUTGOING and INCOMING direction is allowed, since this is a read/write collection");
        }
        this.node = node;
        this.type = type;
        this.direction = direction;
    }

    protected Node getUnderlyingNode() {
        return this.node;
    }

    protected RelationshipType getRelationshipType() {
        return this.type;
    }

    protected Direction getDirection() {
        return this.direction;
    }

    protected Direction getInverseDirection() {
        return this.getDirection().reverse();
    }

    protected boolean directionIsOut() {
        return this.getDirection() == Direction.OUTGOING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(T item) {
        Transaction tx = this.neo().beginTx();
        try {
            if (this.contains(item)) {
                boolean bl = false;
                return bl;
            }
            Node otherNode = this.getNodeFromItem(item);
            Node startNode = this.directionIsOut() ? this.node : otherNode;
            Node endNode = this.directionIsOut() ? otherNode : this.node;
            Relationship relationship = startNode.createRelationshipTo(endNode, this.type);
            this.itemAdded(item, relationship);
            tx.success();
            boolean bl = true;
            return bl;
        }
        finally {
            tx.finish();
        }
    }

    protected void itemAdded(T item, Relationship relationship) {
    }

    protected abstract Node getNodeFromItem(Object var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Transaction tx = this.neo().beginTx();
        try {
            Iterator<Relationship> itr = this.getAllRelationships();
            while (itr.hasNext()) {
                this.removeItem(itr.next());
            }
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object item) {
        Transaction tx = this.neo().beginTx();
        try {
            boolean result = this.findRelationship(item) != null;
            tx.success();
            boolean bl = result;
            return bl;
        }
        finally {
            tx.finish();
        }
    }

    protected boolean shouldIncludeRelationship(Relationship rel) {
        return true;
    }

    protected Iterator<Relationship> getAllRelationships() {
        return new FilteringIterator<Relationship>(this.node.getRelationships(this.type, this.getDirection()).iterator()){

            protected boolean passes(Relationship item) {
                return NeoRelationshipSet.this.shouldIncludeRelationship(item);
            }
        };
    }

    protected Relationship findRelationship(Object item) {
        Node otherNode = this.getNodeFromItem(item);
        Relationship result = null;
        for (Relationship rel : otherNode.getRelationships(this.type, this.getInverseDirection())) {
            if (!this.shouldIncludeRelationship(rel) || !rel.getOtherNode(otherNode).equals(this.node)) continue;
            result = rel;
            break;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Transaction tx = this.neo().beginTx();
        try {
            boolean bl = !this.getAllRelationships().hasNext();
            return bl;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<T> iterator() {
        Transaction tx = this.neo().beginTx();
        try {
            IteratorWrapper result = new IteratorWrapper<T, Relationship>(this.getAllRelationships()){

                protected T underlyingObjectToObject(Relationship rel) {
                    return NeoRelationshipSet.this.newObject(rel.getOtherNode(NeoRelationshipSet.this.node), rel);
                }
            };
            tx.success();
            IteratorWrapper iteratorWrapper = result;
            return iteratorWrapper;
        }
        finally {
            tx.finish();
        }
    }

    protected void removeItem(Relationship rel) {
        rel.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object item) {
        Transaction tx = this.neo().beginTx();
        try {
            Relationship rel = this.findRelationship(item);
            boolean changed = false;
            if (rel != null) {
                this.removeItem(rel);
                changed = true;
            }
            tx.success();
            boolean bl = changed;
            return bl;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> items) {
        Transaction tx = this.neo().beginTx();
        try {
            HashSet<Relationship> relationships = new HashSet<Relationship>();
            Iterator<Relationship> allRelationships = this.getAllRelationships();
            while (allRelationships.hasNext()) {
                relationships.add(allRelationships.next());
            }
            for (Object item : items) {
                Relationship rel = this.findRelationship(item);
                if (rel == null) continue;
                relationships.remove(rel);
            }
            HashSet<T> itemsToRemove = new HashSet<T>();
            for (Relationship rel : relationships) {
                itemsToRemove.add(this.newObject(this.getOtherNode(rel), rel));
            }
            boolean result = this.removeAll(itemsToRemove);
            tx.success();
            boolean bl = result;
            return bl;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Transaction tx = this.neo().beginTx();
        try {
            int counter = 0;
            Iterator<Relationship> itr = this.getAllRelationships();
            while (itr.hasNext()) {
                itr.next();
                ++counter;
            }
            tx.success();
            int n = counter;
            return n;
        }
        finally {
            tx.finish();
        }
    }

    protected abstract T newObject(Node var1, Relationship var2);

    protected Node getOtherNode(Relationship relationship) {
        return relationship.getOtherNode(this.getUnderlyingNode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        Transaction tx = this.neo().beginTx();
        try {
            Iterator<Relationship> itr = this.getAllRelationships();
            Collection result = this.newArrayCollection();
            while (itr.hasNext()) {
                Relationship rel = itr.next();
                result.add(this.newObject(this.getOtherNode(rel), rel));
            }
            tx.success();
            Object[] objectArray = result.toArray();
            return objectArray;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R[] toArray(R[] array) {
        Transaction tx = this.neo().beginTx();
        try {
            Iterator<Relationship> itr = this.getAllRelationships();
            Collection<R> result = this.newArrayCollection();
            while (itr.hasNext()) {
                Relationship rel = itr.next();
                result.add(this.newObject(this.getOtherNode(rel), rel));
            }
            int i = 0;
            for (R item : result) {
                array[i++] = item;
            }
            tx.success();
            R[] RArray = array;
            return RArray;
        }
        finally {
            tx.finish();
        }
    }

    protected <R> Collection<R> newArrayCollection() {
        return new ArrayList();
    }
}

