/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util;

import org.neo4j.api.core.NeoService;
import org.neo4j.util.index.IndexService;
import org.neo4j.util.index.LuceneIndexService;
import org.neo4j.util.index.NeoIndexService;

public class NeoServiceLifecycle {
    private NeoService neoService;
    private IndexService indexService;

    public NeoServiceLifecycle(NeoService neo) {
        this.neoService = neo;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                NeoServiceLifecycle.this.runJvmShutdownHook();
            }
        });
    }

    public void manualShutdown() {
        this.runShutdown();
    }

    protected void runShutdown() {
        if (this.indexService != null) {
            this.indexService.shutdown();
            this.indexService = null;
        }
        if (this.neoService != null) {
            this.neoService.shutdown();
            this.neoService = null;
        }
    }

    protected void runJvmShutdownHook() {
        this.runShutdown();
    }

    public IndexService addLuceneIndexService() {
        this.assertIndexServiceNotInstantiated();
        return this.addIndexService(new LuceneIndexService(this.neoService));
    }

    public IndexService addNeoIndexService() {
        this.assertIndexServiceNotInstantiated();
        return this.addIndexService(new NeoIndexService(this.neoService));
    }

    public IndexService addIndexService(IndexService indexService) {
        this.assertIndexServiceNotInstantiated();
        this.indexService = indexService;
        return indexService;
    }

    public NeoService neo() {
        return this.neoService;
    }

    public IndexService indexService() {
        return this.indexService;
    }

    private void assertIndexServiceNotInstantiated() {
        if (this.indexService != null) {
            throw new UnsupportedOperationException("This utility class only supports zero or one IndexService, there's already a " + this.indexService + " instantiated");
        }
    }
}

