/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util;

import java.util.Iterator;
import org.neo4j.api.core.NeoService;
import org.neo4j.api.core.Node;
import org.neo4j.api.core.Relationship;
import org.neo4j.api.core.RelationshipType;
import org.neo4j.api.core.Transaction;
import org.neo4j.util.NeoRelationshipSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NeoStringSet
extends NeoRelationshipSet<String> {
    private static final String VALUE_KEY = "value";

    public NeoStringSet(NeoService neo, Node node, RelationshipType type) {
        super(neo, node, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Node getNodeFromItem(Object item) {
        String value = (String)item;
        Transaction tx = this.neo().beginTx();
        try {
            Node node = this.neo().createNode();
            node.setProperty(VALUE_KEY, (Object)value);
            tx.success();
            Node node2 = node;
            return node2;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String newObject(Node node, Relationship relationship) {
        Transaction tx = this.neo().beginTx();
        try {
            String string = (String)node.getProperty(VALUE_KEY);
            return string;
        }
        finally {
            tx.finish();
        }
    }

    @Override
    protected Relationship findRelationship(Object item) {
        String value = (String)item;
        Relationship result = null;
        Iterator<Relationship> itr = this.getAllRelationships();
        while (itr.hasNext()) {
            Relationship rel = itr.next();
            Node node = rel.getOtherNode(this.getUnderlyingNode());
            String nodeValue = this.newObject(node, rel);
            if (!value.equals(nodeValue)) continue;
            result = rel;
            break;
        }
        return result;
    }

    @Override
    protected void removeItem(Relationship rel) {
        Node node = this.getOtherNode(rel);
        super.removeItem(rel);
        node.delete();
    }
}

