/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.api.core.Direction;
import org.neo4j.api.core.NeoService;
import org.neo4j.api.core.Node;
import org.neo4j.api.core.NotFoundException;
import org.neo4j.api.core.PropertyContainer;
import org.neo4j.api.core.Relationship;
import org.neo4j.api.core.RelationshipType;
import org.neo4j.api.core.Transaction;
import org.neo4j.util.NeoQueue;
import org.neo4j.util.NeoUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NeoTransactionQueue {
    private static final String INDEX_TX_ID = "txid";
    private static Map<Integer, TxQueue> queueNodes = Collections.synchronizedMap(new HashMap());
    private NeoService neo;
    private NeoUtil neoUtil;
    private Node rootNode;

    public NeoTransactionQueue(NeoService neo, Node rootNode) {
        this.neo = neo;
        this.neoUtil = new NeoUtil(neo);
        this.rootNode = rootNode;
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        Transaction tx = this.neo.beginTx();
        try {
            ArrayList<Relationship> toDelete = new ArrayList<Relationship>();
            for (Relationship rel : this.getRefNode().getRelationships((RelationshipType)QueueRelTypes.UPDATE_QUEUE, Direction.OUTGOING)) {
                TxQueue queue = new TxQueue(rel.getEndNode());
                if (queue.peek() != null) {
                    queueNodes.put(queue.getTxId(), queue);
                    continue;
                }
                toDelete.add(rel);
            }
            for (Relationship rel : toDelete) {
                Node node = rel.getEndNode();
                rel.delete();
                node.delete();
            }
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    public void add(int txId, Map<String, Object> values) {
        TxQueue queue = this.findQueue(txId, true);
        queue.add(values);
    }

    private void remove(TxQueue queue) {
        int txId = queue.getTxId();
        queueNodes.remove(txId);
    }

    protected Node getRefNode() {
        return this.rootNode;
    }

    private TxQueue findQueue(int txId, boolean allowCreate) {
        TxQueue queue = queueNodes.get(txId);
        if (queue != null) {
            return queue;
        }
        if (allowCreate) {
            Node queueNode = this.neo.createNode();
            queueNode.setProperty(INDEX_TX_ID, (Object)txId);
            this.getRefNode().createRelationshipTo(queueNode, (RelationshipType)QueueRelTypes.UPDATE_QUEUE);
            queue = new TxQueue(queueNode);
            queueNodes.put(txId, queue);
            return queue;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, TxQueue> getQueues() {
        Transaction tx = this.neo.beginTx();
        try {
            Map.Entry[] entries;
            HashMap<Integer, TxQueue> map = new HashMap<Integer, TxQueue>();
            for (Map.Entry entry : entries = queueNodes.entrySet().toArray(new Map.Entry[queueNodes.size()])) {
                TxQueue queue = (TxQueue)entry.getValue();
                try {
                    if (queue.peek() == null) continue;
                    map.put(queue.getTxId(), queue);
                }
                catch (NotFoundException e) {
                    queueNodes.remove(entry.getKey());
                }
            }
            tx.success();
            Map<Integer, TxQueue> map2 = Collections.unmodifiableMap(map);
            return map2;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TxQueue {
        private NeoQueue queue;
        private Node node;
        private boolean deleted;

        public TxQueue(Node rootNode) {
            this.queue = new NeoQueue(NeoTransactionQueue.this.neo, rootNode, QueueRelTypes.INTERNAL_QUEUE);
            this.node = rootNode;
        }

        Node getRootNode() {
            return this.node;
        }

        public int getTxId() {
            return (Integer)NeoTransactionQueue.this.neoUtil.getProperty((PropertyContainer)this.node, NeoTransactionQueue.INDEX_TX_ID);
        }

        private void add(Map<String, Object> values) {
            Node node = this.queue.add();
            for (Map.Entry<String, Object> entry : values.entrySet()) {
                node.setProperty(entry.getKey(), entry.getValue());
            }
        }

        public Map<String, Object> peek() {
            Collection<Map<String, Object>> result = this.peek(1);
            return result.isEmpty() ? null : result.iterator().next();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection<Map<String, Object>> peek(int max) {
            if (this.deleted) {
                return null;
            }
            Transaction tx = NeoTransactionQueue.this.neo.beginTx();
            try {
                Node[] nodes;
                ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(max);
                for (Node node : nodes = this.queue.peek(max)) {
                    result.add(this.readEntry(node));
                }
                tx.success();
                ArrayList<Map<String, Object>> arrayList = result;
                return arrayList;
            }
            finally {
                tx.finish();
            }
        }

        private Map<String, Object> readEntry(Node node) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (String key : node.getPropertyKeys()) {
                result.put(key, node.getProperty(key));
            }
            return result;
        }

        public void remove() {
            this.remove(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(int max) {
            if (this.deleted) {
                throw new IllegalStateException("Deleted");
            }
            Transaction tx = NeoTransactionQueue.this.neo.beginTx();
            try {
                this.queue.remove(max);
                if (this.queue.peek() == null) {
                    NeoTransactionQueue.this.remove(this);
                    this.deleted = true;
                }
                tx.success();
            }
            finally {
                tx.finish();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum QueueRelTypes implements RelationshipType
    {
        UPDATE_QUEUE,
        INTERNAL_QUEUE;

    }
}

