/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.transaction.TransactionManager;
import org.neo4j.api.core.Direction;
import org.neo4j.api.core.EmbeddedNeo;
import org.neo4j.api.core.NeoService;
import org.neo4j.api.core.Node;
import org.neo4j.api.core.PropertyContainer;
import org.neo4j.api.core.Relationship;
import org.neo4j.api.core.RelationshipType;
import org.neo4j.api.core.Transaction;
import org.neo4j.impl.event.Event;
import org.neo4j.impl.event.EventData;
import org.neo4j.impl.event.EventListenerAlreadyRegisteredException;
import org.neo4j.impl.event.EventListenerNotRegisteredException;
import org.neo4j.impl.event.EventManager;
import org.neo4j.impl.event.ProActiveEventListener;
import org.neo4j.impl.event.ReActiveEventListener;
import org.neo4j.impl.transaction.LockManager;
import org.neo4j.util.NodeWrapper;
import org.neo4j.util.NodeWrapperRelationshipSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NeoUtil {
    private NeoService neo;

    public NeoUtil(NeoService neo) {
        this.neo = neo;
    }

    public NeoService neo() {
        return this.neo;
    }

    private void assertPropertyKeyNotNull(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Property key can't be null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasProperty(PropertyContainer container, String key) {
        this.assertPropertyKeyNotNull(key);
        Transaction tx = this.neo().beginTx();
        try {
            boolean result = container.hasProperty(key);
            tx.success();
            boolean bl = result;
            return bl;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(PropertyContainer container, String key) {
        this.assertPropertyKeyNotNull(key);
        Transaction tx = this.neo().beginTx();
        try {
            Object result = container.getProperty(key);
            tx.success();
            Object object = result;
            return object;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(PropertyContainer container, String key, Object defaultValue) {
        this.assertPropertyKeyNotNull(key);
        Transaction tx = this.neo().beginTx();
        try {
            Object result = container.getProperty(key, defaultValue);
            tx.success();
            Object object = result;
            return object;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(PropertyContainer container, String key, Object value) {
        this.assertPropertyKeyNotNull(key);
        if (value == null) {
            throw new IllegalArgumentException("Value for property '" + key + "' can't be null");
        }
        Transaction tx = this.neo().beginTx();
        try {
            container.setProperty(key, value);
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> getPropertyValues(PropertyContainer container, String key) {
        Transaction tx = this.neo.beginTx();
        try {
            Object value = container.getProperty(key, null);
            ArrayList<Object> result = value == null ? new ArrayList() : this.neoPropertyAsList(value);
            tx.success();
            ArrayList<Object> arrayList = result;
            return arrayList;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addValueToArray(PropertyContainer container, String key, Object value) {
        Transaction tx = this.neo.beginTx();
        try {
            boolean changed;
            List<Object> values = this.getPropertyValues(container, key);
            boolean bl = changed = values.contains(value) ? false : values.add(value);
            if (changed) {
                container.setProperty(key, this.asNeoProperty(values));
            }
            tx.success();
            boolean bl2 = changed;
            return bl2;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeValueFromArray(PropertyContainer container, String key, Object value) {
        Transaction tx = this.neo.beginTx();
        try {
            List<Object> values = this.getPropertyValues(container, key);
            boolean changed = values.remove(value);
            if (changed) {
                if (values.isEmpty()) {
                    container.removeProperty(key);
                } else {
                    container.setProperty(key, this.asNeoProperty(values));
                }
            }
            tx.success();
            boolean bl = changed;
            return bl;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object removeProperty(PropertyContainer container, String key) {
        this.assertPropertyKeyNotNull(key);
        Transaction tx = this.neo().beginTx();
        try {
            Object oldValue = container.removeProperty(key);
            tx.success();
            Object object = oldValue;
            return object;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Relationship getSingleRelationship(Node node, RelationshipType type, Direction direction) {
        Transaction tx = this.neo().beginTx();
        try {
            Relationship singleRelationship = node.getSingleRelationship(type, direction);
            tx.success();
            Relationship relationship = singleRelationship;
            return relationship;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node getSingleOtherNode(Node node, RelationshipType type, Direction direction) {
        Transaction tx = this.neo().beginTx();
        try {
            Relationship rel = this.getSingleRelationship(node, type, direction);
            Node result = rel == null ? null : rel.getOtherNode(node);
            tx.success();
            Node node2 = result;
            return node2;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Relationship getSingleRelationship(Node node, RelationshipType type) {
        Transaction tx = this.neo().beginTx();
        try {
            Iterator itr = node.getRelationships(new RelationshipType[]{type}).iterator();
            Relationship rel = null;
            if (itr.hasNext()) {
                rel = (Relationship)itr.next();
                if (itr.hasNext()) {
                    throw new RuntimeException(node + " has more than one " + "relationship of type '" + type.name() + "'");
                }
            }
            tx.success();
            Relationship relationship = rel;
            return relationship;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node getSingleOtherNode(Node node, RelationshipType type) {
        Transaction tx = this.neo().beginTx();
        try {
            Relationship rel = this.getSingleRelationship(node, type);
            Node result = rel == null ? null : rel.getOtherNode(node);
            tx.success();
            Node node2 = result;
            return node2;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node getReferenceNode() {
        Transaction tx = this.neo().beginTx();
        try {
            Node referenceNode = this.neo().getReferenceNode();
            tx.success();
            Node node = referenceNode;
            return node;
        }
        finally {
            tx.finish();
        }
    }

    public Node getOrCreateSubReferenceNode(RelationshipType type) {
        return this.getOrCreateSubReferenceNode(type, Direction.OUTGOING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node getOrCreateSubReferenceNode(RelationshipType type, Direction direction) {
        Transaction tx = this.neo().beginTx();
        try {
            Node referenceNode = this.getReferenceNode();
            Node node = null;
            Relationship singleRelationship = referenceNode.getSingleRelationship(type, direction);
            if (singleRelationship != null) {
                node = singleRelationship.getOtherNode(referenceNode);
            } else {
                node = this.neo().createNode();
                referenceNode.createRelationshipTo(node, type);
            }
            tx.success();
            Node node2 = node;
            return node2;
        }
        finally {
            tx.finish();
        }
    }

    public <T extends NodeWrapper> Collection<T> getSubReferenceNodeCollection(RelationshipType type, Class<T> clazz) {
        return new NodeWrapperRelationshipSet<T>(this.neo(), this.getOrCreateSubReferenceNode(type), type, clazz);
    }

    public EventManager getEventManager() {
        return ((EmbeddedNeo)this.neo()).getConfig().getEventModule().getEventManager();
    }

    public LockManager getLockManager() {
        return ((EmbeddedNeo)this.neo()).getConfig().getLockManager();
    }

    public TransactionManager getTransactionManager() {
        return ((EmbeddedNeo)this.neo()).getConfig().getTxModule().getTxManager();
    }

    public void registerReActiveEventListener(ReActiveEventListener listener, Event event) {
        try {
            this.getEventManager().registerReActiveEventListener(listener, event);
        }
        catch (EventListenerAlreadyRegisteredException e) {
            throw new RuntimeException(e);
        }
        catch (EventListenerNotRegisteredException e) {
            throw new RuntimeException(e);
        }
    }

    public void unregisterReActiveEventListener(ReActiveEventListener listener, Event event) {
        try {
            this.getEventManager().unregisterReActiveEventListener(listener, event);
        }
        catch (EventListenerNotRegisteredException e) {
            throw new RuntimeException(e);
        }
    }

    public void registerProActiveEventListener(ProActiveEventListener listener, Event event) {
        try {
            this.getEventManager().registerProActiveEventListener(listener, event);
        }
        catch (EventListenerAlreadyRegisteredException e) {
            throw new RuntimeException(e);
        }
        catch (EventListenerNotRegisteredException e) {
            throw new RuntimeException(e);
        }
    }

    public void unregisterProActiveEventListener(ProActiveEventListener listener, Event event) {
        try {
            this.getEventManager().unregisterProActiveEventListener(listener, event);
        }
        catch (EventListenerNotRegisteredException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean proActiveEvent(Event event, Object data) {
        return this.event(event, data, EventType.PRO_ACTIVE);
    }

    public void reActiveEvent(Event event, Object data) {
        this.event(event, data, EventType.RE_ACTIVE);
    }

    public boolean event(Event event, Object data, EventType ... types) {
        boolean result = true;
        EventData eventData = new EventData(data);
        EventManager eventManager = this.getEventManager();
        for (EventType type : types) {
            if (type == EventType.PRO_ACTIVE) {
                result = eventManager.generateProActiveEvent(event, eventData);
                continue;
            }
            eventManager.generateReActiveEvent(event, eventData);
        }
        return result;
    }

    public Object[] neoPropertyAsArray(Object neoPropertyValue) {
        if (neoPropertyValue.getClass().isArray()) {
            int length = Array.getLength(neoPropertyValue);
            Object[] result = new Object[length];
            for (int i = 0; i < length; ++i) {
                result[i] = Array.get(neoPropertyValue, i);
            }
            return result;
        }
        return new Object[]{neoPropertyValue};
    }

    public List<Object> neoPropertyAsList(Object neoPropertyValue) {
        return new ArrayList<Object>(Arrays.asList(this.neoPropertyAsArray(neoPropertyValue)));
    }

    public Object asNeoProperty(Collection<?> values) {
        if (values.isEmpty()) {
            return null;
        }
        if (values.size() == 1) {
            return values.iterator().next();
        }
        Object array = Array.newInstance(values.iterator().next().getClass(), values.size());
        int index = 0;
        for (Object value : values) {
            Array.set(array, index++, value);
        }
        return array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer incrementAndGetCounter(Node node, String propertyKey) {
        Transaction tx = this.neo.beginTx();
        this.getLockManager().getWriteLock((Object)node);
        try {
            int value = (Integer)node.getProperty(propertyKey, (Object)0);
            node.setProperty(propertyKey, (Object)(++value));
            tx.success();
            Integer n = value;
            return n;
        }
        finally {
            this.getLockManager().releaseWriteLock((Object)node);
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer decrementAndGetCounter(Node node, String propertyKey, int notLowerThan) {
        Transaction tx = this.neo.beginTx();
        this.getLockManager().getWriteLock((Object)node);
        try {
            int value = (Integer)node.getProperty(propertyKey, (Object)0);
            value = --value < notLowerThan ? notLowerThan : value;
            node.setProperty(propertyKey, (Object)value);
            tx.success();
            Integer n = value;
            return n;
        }
        finally {
            this.getLockManager().releaseWriteLock((Object)node);
            tx.finish();
        }
    }

    public String sumNodeContents(Node node) {
        StringBuffer result = new StringBuffer();
        for (Relationship rel : node.getRelationships()) {
            if (rel.getStartNode().equals(node)) {
                result.append(rel.getStartNode() + " ---[" + rel.getType().name() + "]--> " + rel.getEndNode());
            } else {
                result.append(rel.getStartNode() + " <--[" + rel.getType().name() + "]--- " + rel.getEndNode());
            }
            result.append("\n");
        }
        NeoUtil neoUtil = new NeoUtil(this.neo());
        for (String key : node.getPropertyKeys()) {
            for (Object value : neoUtil.neoPropertyAsArray(node.getProperty(key))) {
                result.append("*" + key + "=[" + value + "]");
                result.append("\n");
            }
        }
        return result.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EventType {
        PRO_ACTIVE,
        RE_ACTIVE;

    }
}

