/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util;

import java.lang.reflect.Constructor;
import org.neo4j.api.core.NeoService;
import org.neo4j.api.core.Node;
import org.neo4j.api.core.Transaction;
import org.neo4j.util.NodeWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NodeWrapperImpl
implements NodeWrapper {
    private final NeoService neo;
    private final Node node;

    public static <T extends NodeWrapper> T newInstance(Class<T> instanceClass, NeoService neo, Node node) {
        try {
            Constructor<T> constructor = instanceClass.getConstructor(NeoService.class, Node.class);
            NodeWrapper result = (NodeWrapper)constructor.newInstance(neo, node);
            return (T)result;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends NodeWrapper> T newInstance(Class<T> instanceClass, NeoService neo, long nodeId) {
        Transaction tx = neo.beginTx();
        try {
            Node node = neo.getNodeById(nodeId);
            T result = NodeWrapperImpl.newInstance(instanceClass, neo, node);
            tx.success();
            T t = result;
            return t;
        }
        finally {
            tx.finish();
        }
    }

    protected NodeWrapperImpl(NeoService neo, Node node) {
        this.neo = neo;
        this.node = node;
    }

    @Override
    public Node getUnderlyingNode() {
        return this.node;
    }

    protected NeoService getNeo() {
        return this.neo;
    }

    public boolean equals(Object o) {
        return o != null && this.getClass().equals(o.getClass()) && this.getUnderlyingNode().equals(((NodeWrapper)o).getUnderlyingNode());
    }

    public int hashCode() {
        return this.getUnderlyingNode().hashCode();
    }
}

