/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util;

import org.neo4j.api.core.Direction;
import org.neo4j.api.core.NeoService;
import org.neo4j.api.core.Node;
import org.neo4j.api.core.Relationship;
import org.neo4j.api.core.RelationshipType;
import org.neo4j.util.NeoRelationshipSet;
import org.neo4j.util.NodeWrapper;
import org.neo4j.util.NodeWrapperImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeWrapperRelationshipSet<T extends NodeWrapper>
extends NeoRelationshipSet<T> {
    private Class<? extends T> instanceClass;

    public NodeWrapperRelationshipSet(NeoService neo, Node node, RelationshipType type, Class<? extends T> instanceClass) {
        super(neo, node, type);
        this.instanceClass = instanceClass;
    }

    public NodeWrapperRelationshipSet(NeoService neo, Node node, RelationshipType type, Direction direction, Class<? extends T> instanceClass) {
        super(neo, node, type, direction);
        this.instanceClass = instanceClass;
    }

    protected Class<? extends T> getInstanceClass() {
        return this.instanceClass;
    }

    @Override
    protected T newObject(Node node, Relationship relationship) {
        return NodeWrapperImpl.newInstance(this.getInstanceClass(), this.neo(), node);
    }

    @Override
    protected Node getNodeFromItem(Object item) {
        return ((NodeWrapper)item).getUnderlyingNode();
    }
}

