/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util;

import org.neo4j.api.core.NeoService;
import org.neo4j.api.core.Node;
import org.neo4j.api.core.RelationshipType;
import org.neo4j.util.Migration;
import org.neo4j.util.Migrator;
import org.neo4j.util.NeoUtil;

public abstract class SimpleMigration
extends Migration {
    private String versionClassPrefix = this.getMigratorPrefix();

    public SimpleMigration(NeoService neo, RelationshipType subReferenceType) {
        super(neo, SimpleMigration.getConfigNodeFromType(neo, subReferenceType));
    }

    public SimpleMigration(NeoService neo) {
        this(neo, MigrationRelationshipTypes.REF_MIGRATION);
    }

    private static Node getConfigNodeFromType(NeoService neo, RelationshipType type) {
        return new NeoUtil(neo).getOrCreateSubReferenceNode(type);
    }

    protected String getMigratorPrefix() {
        String className = this.getClass().getName();
        int dotIndex = className.lastIndexOf(46);
        String result = className.substring(0, dotIndex + 1) + "Migrator";
        return result;
    }

    protected Migrator findMigrator(int version) {
        String className = this.versionClassPrefix + version;
        try {
            Class<Migrator> cls = Class.forName(className).asSubclass(Migrator.class);
            return cls.newInstance();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MigrationRelationshipTypes implements RelationshipType
    {
        REF_MIGRATION;

    }
}

