/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util;

import org.neo4j.impl.event.Event;
import org.neo4j.impl.event.EventData;
import org.neo4j.impl.event.ProActiveEventListener;
import org.neo4j.util.EventBufferFilter;
import org.neo4j.util.EventContext;
import org.neo4j.util.TransactionEventManager;

public abstract class TransactionEventListener
implements ProActiveEventListener {
    private TransactionEventManager manager;

    public TransactionEventListener(TransactionEventManager manager) {
        this.manager = manager;
    }

    protected abstract Event[] getEvents();

    public void start() {
        for (Event event : this.getEvents()) {
            this.manager.registerEventListener(this, event);
        }
    }

    public void stop() {
        for (Event event : this.getEvents()) {
            this.manager.unregisterEventListener(this, event);
        }
    }

    protected EventBufferFilter newFilter() {
        return EventBufferFilter.HOLLOW_EVENT_FILTER;
    }

    public boolean proActiveEventReceived(Event event, EventData data) {
        if (event != TransactionEventManager.TX_EVENT_BUFFER) {
            return true;
        }
        EventContext[] contexts = (EventContext[])data.getData();
        contexts = this.newFilter().filter(contexts);
        return this.handleEventBuffer(contexts);
    }

    protected abstract boolean handleEventBuffer(EventContext[] var1);
}

