/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.neo4j.api.core.NeoService;
import org.neo4j.impl.event.Event;
import org.neo4j.impl.event.EventData;
import org.neo4j.impl.event.ProActiveEventListener;
import org.neo4j.util.EventContext;
import org.neo4j.util.NeoUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionEventManager {
    public static final Event TX_EVENT_BUFFER = new TransactionEvent("TX_EVENT_BUFFER");
    private ConcurrentMap<Transaction, TransactionHook> transactions = new ConcurrentHashMap<Transaction, TransactionHook>();
    private InternalEventListener internalListener = new InternalEventListener();
    private Map<Event, Set<ProActiveEventListener>> listeners = new HashMap<Event, Set<ProActiveEventListener>>();
    private Set<Event> registeredEvents = new HashSet<Event>();
    private NeoUtil neoUtil;
    private TransactionHookFactory hookFactory = new TransactionHookFactory(){

        public TransactionHook newHook(Transaction tx) {
            return new TransactionHook(tx);
        }
    };
    private boolean wrapEventsInTx;

    public TransactionEventManager(NeoService neo) {
        this(neo, false);
    }

    public TransactionEventManager(NeoService neo, boolean wrapEventsInTx) {
        this.neoUtil = new NeoUtil(neo);
        this.wrapEventsInTx = wrapEventsInTx;
    }

    private TransactionHook getTransactionHook(Transaction tx) {
        return (TransactionHook)this.transactions.get(tx);
    }

    private TransactionHook createTransactionHook(Transaction tx) {
        TransactionHook hook = this.hookFactory.newHook(tx);
        TransactionHook previous = this.transactions.putIfAbsent(tx, hook);
        if (previous != null) {
            throw new RuntimeException("There was a previous tx id " + tx);
        }
        return hook;
    }

    private void removeTransactionHook(TransactionHook hook) {
        if (!this.transactions.remove(hook.tx, hook)) {
            throw new RuntimeException("Couldn't remove tx hook " + hook.tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<ProActiveEventListener> getListenersSet(Event event) {
        Map<Event, Set<ProActiveEventListener>> map = this.listeners;
        synchronized (map) {
            Set<ProActiveEventListener> listenersForEvent = this.listeners.get(event);
            if (listenersForEvent == null) {
                listenersForEvent = new HashSet<ProActiveEventListener>();
                this.listeners.put(event, listenersForEvent);
            }
            return listenersForEvent;
        }
    }

    public void setTransactionHookFactory(TransactionHookFactory factory) {
        this.hookFactory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEventListener(ProActiveEventListener listener, Event event) {
        Map<Event, Set<ProActiveEventListener>> map = this.listeners;
        synchronized (map) {
            Set<ProActiveEventListener> listenersForEvent = this.getListenersSet(event);
            if (listenersForEvent.contains(listener)) {
                throw new RuntimeException("Listener " + listener + " already registered for " + event);
            }
            listenersForEvent.add(listener);
        }
        this.registerInternalEventListener(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerInternalEventListener(Event event) {
        Set<Event> set = this.registeredEvents;
        synchronized (set) {
            if (!this.registeredEvents.contains(event)) {
                this.neoUtil.registerProActiveEventListener(this.internalListener, event);
                this.registeredEvents.add(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterEventListener(ProActiveEventListener listener, Event event) {
        Map<Event, Set<ProActiveEventListener>> map = this.listeners;
        synchronized (map) {
            Set<ProActiveEventListener> listenersForEvent = this.getListenersSet(event);
            if (!listenersForEvent.contains(listener)) {
                throw new RuntimeException("Listener " + listener + " not registered for " + event);
            }
            listenersForEvent.remove(listener);
        }
        this.unregisterInternalEventListener(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterInternalEventListener(Event event) {
        Set<Event> set = this.registeredEvents;
        synchronized (set) {
            if (this.registeredEvents.contains(event)) {
                this.neoUtil.unregisterProActiveEventListener(this.internalListener, event);
                this.registeredEvents.remove(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendEvent(EventContext event) {
        Map<Event, Set<ProActiveEventListener>> map = this.listeners;
        synchronized (map) {
            for (ProActiveEventListener listener : this.getListenersSet(event.getEvent())) {
                this.safeSendEvent(listener, event.getEvent(), event.getData());
            }
        }
    }

    private void sendEventBuffer(ProActiveEventListener listener, EventContext[] events) {
        this.safeSendEvent(listener, TX_EVENT_BUFFER, new EventData((Object)events));
    }

    private void safeSendEvent(ProActiveEventListener listener, Event event, EventData data) {
        try {
            listener.proActiveEventReceived(event, data);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void flushEvents() {
        try {
            TransactionHook hook = this.getTransactionHook(this.neoUtil.getTransactionManager().getTransaction());
            if (hook == null) {
                return;
            }
            hook.flushEvents();
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
    }

    protected static class TransactionEvent
    extends Event {
        TransactionEvent(String name) {
            super(name);
        }
    }

    private class InternalEventListener
    implements ProActiveEventListener {
        private InternalEventListener() {
        }

        public boolean proActiveEventReceived(Event event, EventData data) {
            try {
                Transaction tx = TransactionEventManager.this.neoUtil.getTransactionManager().getTransaction();
                TransactionHook hook = TransactionEventManager.this.getTransactionHook(tx);
                if (hook == null) {
                    hook = TransactionEventManager.this.createTransactionHook(tx);
                    tx.registerSynchronization((Synchronization)hook);
                }
                hook.queueEvent(event, data);
            }
            catch (SystemException e) {
                throw new RuntimeException(e);
            }
            catch (RollbackException e) {
                throw new RuntimeException(e);
            }
            return true;
        }
    }

    public class TransactionHook
    implements Synchronization {
        private Transaction tx;
        private List<EventContext> events;
        private EventList eventList;

        TransactionHook(Transaction tx) {
            this.tx = tx;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void sendEvents() {
            if (this.events == null) {
                return;
            }
            try {
                this.beforeSendingEvents();
                this.eventList = new EventList();
                for (EventContext context : this.events) {
                    this.eventList.sendEvent(context);
                }
                this.eventList.sendEventBuffer();
            }
            finally {
                this.afterSendingEvents();
            }
        }

        private void flushEvents() {
            this.sendEvents();
            this.events = null;
        }

        protected void beforeSendingEvents() {
        }

        protected void afterSendingEvents() {
        }

        protected void queueEvent(Event event, EventData data) {
            if (this.events == null) {
                this.events = new ArrayList<EventContext>();
            }
            this.events.add(new EventContext(event, data));
        }

        public void afterCompletion(int status) {
            TransactionEventManager.this.removeTransactionHook(this);
            if (status != 3) {
                return;
            }
            Thread thread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    org.neo4j.api.core.Transaction tx = TransactionEventManager.this.wrapEventsInTx ? TransactionEventManager.this.neoUtil.neo().beginTx() : null;
                    try {
                        TransactionHook.this.flushEvents();
                        if (TransactionEventManager.this.wrapEventsInTx) {
                            tx.success();
                        }
                    }
                    finally {
                        if (TransactionEventManager.this.wrapEventsInTx) {
                            tx.finish();
                        }
                    }
                }
            };
            thread.start();
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void beforeCompletion() {
        }
    }

    public static interface TransactionHookFactory {
        public TransactionHook newHook(Transaction var1);
    }

    private class EventList {
        private Map<ProActiveEventListener, List<EventContext>> eventsPerListener = new HashMap<ProActiveEventListener, List<EventContext>>();

        private EventList() {
        }

        void sendEvent(EventContext context) {
            TransactionEventManager.this.sendEvent(context);
            this.bufferEvent(context);
        }

        private void bufferEvent(EventContext context) {
            for (ProActiveEventListener listener : TransactionEventManager.this.getListenersSet(context.getEvent())) {
                List<EventContext> eventList = this.eventsPerListener.get(listener);
                if (eventList == null) {
                    eventList = new ArrayList<EventContext>();
                    this.eventsPerListener.put(listener, eventList);
                }
                eventList.add(context);
            }
        }

        void sendEventBuffer() {
            for (ProActiveEventListener listener : this.eventsPerListener.keySet()) {
                List<EventContext> list = this.eventsPerListener.get(listener);
                EventContext[] events = list.toArray(new EventContext[list.size()]);
                TransactionEventManager.this.sendEventBuffer(listener, events);
            }
        }
    }
}

