/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import org.neo4j.api.core.NeoService;
import org.neo4j.impl.event.Event;
import org.neo4j.impl.event.EventData;
import org.neo4j.impl.event.ProActiveEventListener;
import org.neo4j.util.EventContext;
import org.neo4j.util.EventFilter;
import org.neo4j.util.NeoUtil;

public abstract class TxAwareProActiveListener
implements ProActiveEventListener {
    private NeoUtil neoUtil;
    private ConcurrentMap<Transaction, EventFilter> eventLists = new ConcurrentHashMap<Transaction, EventFilter>();

    public TxAwareProActiveListener(NeoService neo) {
        this.neoUtil = new NeoUtil(neo);
    }

    protected abstract Event[] getEvents();

    protected EventFilter newFilter() {
        return EventFilter.HOLLOW_EVENT_FILTER;
    }

    public void register() {
        for (Event event : this.getEvents()) {
            this.neoUtil.registerProActiveEventListener(this, event);
        }
    }

    public void unregister() {
        for (Event event : this.getEvents()) {
            this.neoUtil.unregisterProActiveEventListener(this, event);
        }
    }

    protected abstract boolean handleEvent(Event var1, EventData var2);

    protected void txStarted() {
    }

    protected void txEnded(boolean committed) {
    }

    public final boolean proActiveEventReceived(Event event, EventData data) {
        boolean result = true;
        try {
            final Transaction tx = this.neoUtil.getTransactionManager().getTransaction();
            EventContext context = new EventContext(event, data);
            EventFilter filter = (EventFilter)this.eventLists.get(tx);
            if (filter == null) {
                filter = this.newFilter();
                this.eventLists.put(tx, filter);
                tx.registerSynchronization(new Synchronization(){

                    public void afterCompletion(int status) {
                        TxAwareProActiveListener.this.eventLists.remove(tx);
                    }

                    public void beforeCompletion() {
                    }
                });
            }
            if (filter.pass(context.getEvent(), context.getData())) {
                result = this.handleEvent(context.getEvent(), context.getData());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }
}

