/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util.index;

import org.neo4j.api.core.NeoService;
import org.neo4j.api.core.Node;
import org.neo4j.api.core.Transaction;
import org.neo4j.util.index.IndexService;
import org.neo4j.util.index.IndexServiceQueue;
import org.neo4j.util.index.Isolation;

abstract class GenericIndexService
implements IndexService {
    private final NeoService neo;
    private final IndexServiceQueue queue;
    private ThreadLocal<Isolation> threadIsolation = new ThreadLocal<Isolation>(){

        @Override
        protected Isolation initialValue() {
            return Isolation.SAME_TX;
        }
    };

    protected abstract void removeIndexThisTx(Node var1, String var2, Object var3);

    protected abstract void indexThisTx(Node var1, String var2, Object var3);

    public GenericIndexService(NeoService service) {
        if (service == null) {
            throw new IllegalArgumentException("Null neo service");
        }
        this.neo = service;
        this.queue = new IndexServiceQueue(this);
        this.queue.start();
    }

    public void index(Node node, String key, Object value) {
        Isolation level = this.threadIsolation.get();
        if (level == Isolation.SAME_TX) {
            this.indexThisTx(node, key, value);
        } else {
            this.queue.queueIndex(level, node, key, value);
        }
    }

    public void removeIndex(Node node, String key, Object value) {
        Isolation level = this.threadIsolation.get();
        if (level == Isolation.SAME_TX) {
            this.removeIndexThisTx(node, key, value);
        } else {
            this.queue.queueRemove(level, node, key, value);
        }
    }

    protected NeoService getNeo() {
        return this.neo;
    }

    public void setIsolation(Isolation level) {
        this.threadIsolation.set(level);
    }

    public Isolation getIsolation() {
        return this.threadIsolation.get();
    }

    protected Transaction beginTx() {
        return this.neo.beginTx();
    }

    public void shutdown() {
        this.queue.stopRunning();
    }

    protected IndexServiceQueue getQueue() {
        return this.queue;
    }
}

