/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util.index;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.neo4j.impl.transaction.xaframework.LogBuffer;
import org.neo4j.impl.transaction.xaframework.XaCommand;

abstract class LuceneCommand
extends XaCommand {
    private final long nodeId;
    private final String key;
    private final String value;
    private static final byte ADD_COMMAND = 1;
    private static final byte REMOVE_COMMAND = 2;

    LuceneCommand(long nodeId, String key, String value) {
        this.nodeId = nodeId;
        this.key = key;
        this.value = value;
    }

    LuceneCommand(CommandData data) {
        this.nodeId = data.nodeId;
        this.key = data.key;
        this.value = data.value;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    static CommandData readCommandData(ReadableByteChannel channel, ByteBuffer buffer) throws IOException {
        buffer.clear();
        buffer.limit(16);
        if (channel.read(buffer) != buffer.limit()) {
            return null;
        }
        buffer.flip();
        long nodeId = buffer.getLong();
        int keyCharLength = buffer.getInt();
        int valueCharLength = buffer.getInt();
        char[] keyChars = new char[keyCharLength];
        keyChars = LuceneCommand.readCharArray(channel, buffer, keyChars);
        if (keyChars == null) {
            return null;
        }
        String key = new String(keyChars);
        char[] valueChars = new char[valueCharLength];
        if ((valueChars = LuceneCommand.readCharArray(channel, buffer, valueChars)) == null) {
            return null;
        }
        String value = new String(valueChars);
        return new CommandData(nodeId, key, value);
    }

    private static char[] readCharArray(ReadableByteChannel channel, ByteBuffer buffer, char[] charArray) throws IOException {
        buffer.clear();
        int bytesLeft = charArray.length * 2;
        int maxSize = buffer.capacity();
        int offset = 0;
        while (bytesLeft > 0) {
            if (bytesLeft > maxSize) {
                buffer.limit(maxSize);
                bytesLeft -= maxSize;
            } else {
                buffer.limit(bytesLeft);
                bytesLeft = 0;
            }
            if (channel.read(buffer) != buffer.limit()) {
                return null;
            }
            buffer.flip();
            assert (buffer.limit() % 2 == 0);
            int length = buffer.limit() / 2;
            buffer.asCharBuffer().get(charArray, offset, length);
            offset += length;
        }
        return charArray;
    }

    static XaCommand readCommand(ReadableByteChannel channel, ByteBuffer buffer) throws IOException {
        buffer.clear();
        buffer.limit(1);
        if (channel.read(buffer) != buffer.limit()) {
            return null;
        }
        buffer.flip();
        byte commandType = buffer.get();
        CommandData data = LuceneCommand.readCommandData(channel, buffer);
        if (data == null) {
            return null;
        }
        switch (commandType) {
            case 1: {
                return new AddCommand(data);
            }
            case 2: {
                return new RemoveCommand(data);
            }
        }
        throw new IOException("Unknown command type[" + commandType + "]");
    }

    private static class CommandData {
        private final long nodeId;
        private final String key;
        private final String value;

        CommandData(long nodeId, String key, String value) {
            this.nodeId = nodeId;
            this.key = key;
            this.value = value;
        }
    }

    static class RemoveCommand
    extends LuceneCommand {
        RemoveCommand(long nodeId, String key, String value) {
            super(nodeId, key, value);
        }

        RemoveCommand(CommandData data) {
            super(data);
        }

        public void execute() {
        }

        public void writeToFile(LogBuffer buffer) throws IOException {
            buffer.put((byte)2);
            buffer.putLong(this.getNodeId());
            char[] keyChars = this.getKey().toCharArray();
            buffer.putInt(keyChars.length);
            char[] valueChars = this.getValue().toCharArray();
            buffer.putInt(valueChars.length);
            buffer.put(keyChars);
            buffer.put(valueChars);
        }
    }

    static class AddCommand
    extends LuceneCommand {
        AddCommand(long nodeId, String key, String value) {
            super(nodeId, key, value);
        }

        AddCommand(CommandData data) {
            super(data);
        }

        public void execute() {
        }

        public void writeToFile(LogBuffer buffer) throws IOException {
            buffer.put((byte)1);
            buffer.putLong(this.getNodeId());
            char[] keyChars = this.getKey().toCharArray();
            buffer.putInt(keyChars.length);
            char[] valueChars = this.getValue().toCharArray();
            buffer.putInt(valueChars.length);
            buffer.put(keyChars);
            buffer.put(valueChars);
        }
    }
}

