/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util.index;

import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.neo4j.api.core.NeoService;
import org.neo4j.util.index.LuceneDataSource;
import org.neo4j.util.index.LuceneFulltextDataSource;
import org.neo4j.util.index.LuceneIndexService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneFulltextIndexService
extends LuceneIndexService {
    protected static final String DOC_INDEX_SOURCE_KEY = "index_source";

    public LuceneFulltextIndexService(NeoService neo) {
        super(neo);
    }

    @Override
    protected Class<? extends LuceneDataSource> getDataSourceClass() {
        return LuceneFulltextDataSource.class;
    }

    @Override
    protected String getDirName() {
        return super.getDirName() + "-fulltext";
    }

    @Override
    protected byte[] getXaResourceId() {
        return "262374".getBytes();
    }

    @Override
    protected Query formQuery(String key, Object value) {
        return new TermQuery(new Term("index", value.toString().toLowerCase()));
    }

    @Override
    public void enableCache(String key, int maxNumberOfCachedEntries) {
        throw new UnsupportedOperationException();
    }
}

